/*!
[config]
name: Test short clamp built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: clamp short1
kernel_name: test_1_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[5] 64 -16384 1 -64 0  tolerance 0 
arg_in: 1 buffer short[5] 92 -32768 64 -128 -1 
arg_in: 2 buffer short[5] 0 -16384 0 -64 0 
arg_in: 3 buffer short[5] 64 0 1 0 1 

[test]
name: clamp short2
kernel_name: test_2_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[10] 64 64 -16384 -16384 1 1 -64 -64 0 0  tolerance 0 
arg_in: 1 buffer short[10] 92 92 -32768 -32768 64 64 -128 -128 -1 -1 
arg_in: 2 buffer short[10] 0 0 -16384 -16384 0 0 -64 -64 0 0 
arg_in: 3 buffer short[10] 64 64 0 0 1 1 0 0 1 1 

[test]
name: tss_clamp short2
kernel_name: test_tss_2_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[10] 64 64 -16384 -16384 1 1 -64 -64 0 0  tolerance 0 
arg_in: 1 buffer short[10] 92 92 -32768 -32768 64 64 -128 -128 -1 -1 
arg_in: 2 buffer short[5] 0 -16384 0 -64 0
arg_in: 3 buffer short[5] 64 0 1 0 1

[test]
name: clamp short4
kernel_name: test_4_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[20] 64 64 64 64 -16384 -16384 -16384 -16384 1 1 1 1 -64 -64 -64 -64 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[20] 92 92 92 92 -32768 -32768 -32768 -32768 64 64 64 64 -128 -128 -128 -128 -1 -1 -1 -1 
arg_in: 2 buffer short[20] 0 0 0 0 -16384 -16384 -16384 -16384 0 0 0 0 -64 -64 -64 -64 0 0 0 0 
arg_in: 3 buffer short[20] 64 64 64 64 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 

[test]
name: tss_clamp short4
kernel_name: test_tss_4_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[20] 64 64 64 64 -16384 -16384 -16384 -16384 1 1 1 1 -64 -64 -64 -64 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[20] 92 92 92 92 -32768 -32768 -32768 -32768 64 64 64 64 -128 -128 -128 -128 -1 -1 -1 -1 
arg_in: 2 buffer short[5] 0 -16384 0 -64 0
arg_in: 3 buffer short[5] 64 0 1 0 1

[test]
name: clamp short8
kernel_name: test_8_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[40] 64 64 64 64 64 64 64 64 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[40] 92 92 92 92 92 92 92 92 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer short[40] 0 0 0 0 0 0 0 0 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 
arg_in: 3 buffer short[40] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp short8
kernel_name: test_tss_8_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[40] 64 64 64 64 64 64 64 64 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[40] 92 92 92 92 92 92 92 92 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer short[5] 0 -16384 0 -64 0
arg_in: 3 buffer short[5] 64 0 1 0 1

[test]
name: clamp short16
kernel_name: test_16_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[80] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer short[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer short[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp short16
kernel_name: test_tss_16_clamp_short
global_size: 5 0 0

arg_out: 0 buffer short[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[80] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer short[5] 0 -16384 0 -64 0
arg_in: 3 buffer short[5] 64 0 1 0 1

!*/

kernel void test_1_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  out[get_global_id(0)] = clamp(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_clamp_short(global short* out, global short* in0, global short* in1, global short* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

