/*!
[config]
name: Test short abs_diff built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs_diff short1
kernel_name: test_1_abs_diff_short
global_size: 7 0 0

arg_out: 0 buffer ushort[7] 0 1 1 65535 65535 1 15  tolerance 0 
arg_in: 1 buffer short[7] 0 1 0 -32768 32767 0 -8 
arg_in: 2 buffer short[7] 0 0 1 32767 -32768 1 7 

[test]
name: abs_diff short2
kernel_name: test_2_abs_diff_short
global_size: 7 0 0

arg_out: 0 buffer ushort[14] 0 0 1 1 1 1 65535 65535 65535 65535 1 1 15 15  tolerance 0 
arg_in: 1 buffer short[14] 0 0 1 1 0 0 -32768 -32768 32767 32767 0 0 -8 -8 
arg_in: 2 buffer short[14] 0 0 0 0 1 1 32767 32767 -32768 -32768 1 1 7 7 

[test]
name: abs_diff short4
kernel_name: test_4_abs_diff_short
global_size: 7 0 0

arg_out: 0 buffer ushort[28] 0 0 0 0 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 15 15 15 15  tolerance 0 
arg_in: 1 buffer short[28] 0 0 0 0 1 1 1 1 0 0 0 0 -32768 -32768 -32768 -32768 32767 32767 32767 32767 0 0 0 0 -8 -8 -8 -8 
arg_in: 2 buffer short[28] 0 0 0 0 0 0 0 0 1 1 1 1 32767 32767 32767 32767 -32768 -32768 -32768 -32768 1 1 1 1 7 7 7 7 

[test]
name: abs_diff short8
kernel_name: test_8_abs_diff_short
global_size: 7 0 0

arg_out: 0 buffer ushort[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer short[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer short[56] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 

[test]
name: abs_diff short16
kernel_name: test_16_abs_diff_short
global_size: 7 0 0

arg_out: 0 buffer ushort[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer short[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer short[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_abs_diff_short(global ushort* out, global short* in0, global short* in1){
  out[get_global_id(0)] = abs_diff(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_abs_diff_short(global ushort* out, global short* in0, global short* in1){
  vstore2(abs_diff(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_abs_diff_short(global ushort* out, global short* in0, global short* in1){
  vstore4(abs_diff(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_abs_diff_short(global ushort* out, global short* in0, global short* in1){
  vstore8(abs_diff(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_abs_diff_short(global ushort* out, global short* in0, global short* in1){
  vstore16(abs_diff(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

