/*!
[config]
name: Test short abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs short1
kernel_name: test_1_abs_short
global_size: 6 0 0

arg_out: 0 buffer ushort[6] 0 2 32768 32767 1 13  tolerance 0 
arg_in: 1 buffer short[6] 0 2 -32768 32767 -1 -13 

[test]
name: abs short2
kernel_name: test_2_abs_short
global_size: 6 0 0

arg_out: 0 buffer ushort[12] 0 0 2 2 32768 32768 32767 32767 1 1 13 13  tolerance 0 
arg_in: 1 buffer short[12] 0 0 2 2 -32768 -32768 32767 32767 -1 -1 -13 -13 

[test]
name: abs short4
kernel_name: test_4_abs_short
global_size: 6 0 0

arg_out: 0 buffer ushort[24] 0 0 0 0 2 2 2 2 32768 32768 32768 32768 32767 32767 32767 32767 1 1 1 1 13 13 13 13  tolerance 0 
arg_in: 1 buffer short[24] 0 0 0 0 2 2 2 2 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -1 -1 -1 -1 -13 -13 -13 -13 

[test]
name: abs short8
kernel_name: test_8_abs_short
global_size: 6 0 0

arg_out: 0 buffer ushort[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 32768 32768 32768 32768 32768 32768 32768 32768 32767 32767 32767 32767 32767 32767 32767 32767 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer short[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 

[test]
name: abs short16
kernel_name: test_16_abs_short
global_size: 6 0 0

arg_out: 0 buffer ushort[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer short[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 

!*/

kernel void test_1_abs_short(global ushort* out, global short* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_short(global ushort* out, global short* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_short(global ushort* out, global short* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_short(global ushort* out, global short* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_short(global ushort* out, global short* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

