/*!
[config]
name: Test long popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount long1
kernel_name: test_1_popcount_long
global_size: 5 0 0

arg_out: 0 buffer long[5] 1 2 0 63 1  tolerance 0 
arg_in: 1 buffer long[5] 1 3 0 9223372036854775807 -9223372036854775808 

[test]
name: popcount long2
kernel_name: test_2_popcount_long
global_size: 5 0 0

arg_out: 0 buffer long[10] 1 1 2 2 0 0 63 63 1 1  tolerance 0 
arg_in: 1 buffer long[10] 1 1 3 3 0 0 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 

[test]
name: popcount long4
kernel_name: test_4_popcount_long
global_size: 5 0 0

arg_out: 0 buffer long[20] 1 1 1 1 2 2 2 2 0 0 0 0 63 63 63 63 1 1 1 1  tolerance 0 
arg_in: 1 buffer long[20] 1 1 1 1 3 3 3 3 0 0 0 0 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 

[test]
name: popcount long8
kernel_name: test_8_popcount_long
global_size: 5 0 0

arg_out: 0 buffer long[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 63 63 63 63 63 63 63 63 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer long[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 

[test]
name: popcount long16
kernel_name: test_16_popcount_long
global_size: 5 0 0

arg_out: 0 buffer long[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer long[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 

!*/

kernel void test_1_popcount_long(global long* out, global long* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_long(global long* out, global long* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_long(global long* out, global long* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_long(global long* out, global long* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_long(global long* out, global long* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

