/*!
[config]
name: Test long clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz long1
kernel_name: test_1_clz_long
global_size: 5 0 0

arg_out: 0 buffer long[5] 63 57 64 1 0  tolerance 0 
arg_in: 1 buffer long[5] 1 64 0 9223372036854775807 -9223372036854775808 

[test]
name: clz long2
kernel_name: test_2_clz_long
global_size: 5 0 0

arg_out: 0 buffer long[10] 63 63 57 57 64 64 1 1 0 0  tolerance 0 
arg_in: 1 buffer long[10] 1 1 64 64 0 0 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 

[test]
name: clz long4
kernel_name: test_4_clz_long
global_size: 5 0 0

arg_out: 0 buffer long[20] 63 63 63 63 57 57 57 57 64 64 64 64 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[20] 1 1 1 1 64 64 64 64 0 0 0 0 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 

[test]
name: clz long8
kernel_name: test_8_clz_long
global_size: 5 0 0

arg_out: 0 buffer long[40] 63 63 63 63 63 63 63 63 57 57 57 57 57 57 57 57 64 64 64 64 64 64 64 64 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 

[test]
name: clz long16
kernel_name: test_16_clz_long
global_size: 5 0 0

arg_out: 0 buffer long[80] 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 

!*/

kernel void test_1_clz_long(global long* out, global long* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_long(global long* out, global long* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_long(global long* out, global long* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_long(global long* out, global long* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_long(global long* out, global long* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

