/*!
[config]
name: Test long clamp built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: clamp long1
kernel_name: test_1_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[5] 64 -4611686018427387904 1 -64 0  tolerance 0 
arg_in: 1 buffer long[5] 92 -9223372036854775808 64 -128 -1 
arg_in: 2 buffer long[5] 0 -4611686018427387904 0 -64 0 
arg_in: 3 buffer long[5] 64 0 1 0 1 

[test]
name: clamp long2
kernel_name: test_2_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[10] 64 64 -4611686018427387904 -4611686018427387904 1 1 -64 -64 0 0  tolerance 0 
arg_in: 1 buffer long[10] 92 92 -9223372036854775808 -9223372036854775808 64 64 -128 -128 -1 -1 
arg_in: 2 buffer long[10] 0 0 -4611686018427387904 -4611686018427387904 0 0 -64 -64 0 0 
arg_in: 3 buffer long[10] 64 64 0 0 1 1 0 0 1 1 

[test]
name: tss_clamp long2
kernel_name: test_tss_2_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[10] 64 64 -4611686018427387904 -4611686018427387904 1 1 -64 -64 0 0  tolerance 0 
arg_in: 1 buffer long[10] 92 92 -9223372036854775808 -9223372036854775808 64 64 -128 -128 -1 -1 
arg_in: 2 buffer long[5] 0 -4611686018427387904 0 -64 0
arg_in: 3 buffer long[5] 64 0 1 0 1

[test]
name: clamp long4
kernel_name: test_4_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[20] 64 64 64 64 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 1 1 1 1 -64 -64 -64 -64 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[20] 92 92 92 92 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 64 64 64 64 -128 -128 -128 -128 -1 -1 -1 -1 
arg_in: 2 buffer long[20] 0 0 0 0 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 0 0 0 0 -64 -64 -64 -64 0 0 0 0 
arg_in: 3 buffer long[20] 64 64 64 64 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 

[test]
name: tss_clamp long4
kernel_name: test_tss_4_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[20] 64 64 64 64 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 1 1 1 1 -64 -64 -64 -64 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[20] 92 92 92 92 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 64 64 64 64 -128 -128 -128 -128 -1 -1 -1 -1 
arg_in: 2 buffer long[5] 0 -4611686018427387904 0 -64 0
arg_in: 3 buffer long[5] 64 0 1 0 1

[test]
name: clamp long8
kernel_name: test_8_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[40] 64 64 64 64 64 64 64 64 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[40] 92 92 92 92 92 92 92 92 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer long[40] 0 0 0 0 0 0 0 0 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 
arg_in: 3 buffer long[40] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp long8
kernel_name: test_tss_8_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[40] 64 64 64 64 64 64 64 64 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[40] 92 92 92 92 92 92 92 92 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer long[5] 0 -4611686018427387904 0 -64 0
arg_in: 3 buffer long[5] 64 0 1 0 1

[test]
name: clamp long16
kernel_name: test_16_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[80] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer long[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer long[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp long16
kernel_name: test_tss_16_clamp_long
global_size: 5 0 0

arg_out: 0 buffer long[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 -4611686018427387904 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer long[80] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer long[5] 0 -4611686018427387904 0 -64 0
arg_in: 3 buffer long[5] 64 0 1 0 1

!*/

kernel void test_1_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  out[get_global_id(0)] = clamp(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_clamp_long(global long* out, global long* in0, global long* in1, global long* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

