/*!
[config]
name: Test long add_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: add_sat long1
kernel_name: test_1_add_sat_long
global_size: 7 0 0

arg_out: 0 buffer long[7] 9223372036854775807 9223372036854775807 0 -2 9223372036854775744 -9223372036854775808 -9223372036854775808  tolerance 0 
arg_in: 1 buffer long[7] 9223372036854775807 9223372036854775806 32 -8 9223372036854775807 -9223372036854775808 -9223372036854775798 
arg_in: 2 buffer long[7] 64 50 -32 6 -63 -12 -50 

[test]
name: add_sat long2
kernel_name: test_2_add_sat_long
global_size: 7 0 0

arg_out: 0 buffer long[14] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 -2 -2 9223372036854775744 9223372036854775744 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808  tolerance 0 
arg_in: 1 buffer long[14] 9223372036854775807 9223372036854775807 9223372036854775806 9223372036854775806 32 32 -8 -8 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775798 -9223372036854775798 
arg_in: 2 buffer long[14] 64 64 50 50 -32 -32 6 6 -63 -63 -12 -12 -50 -50 

[test]
name: add_sat long4
kernel_name: test_4_add_sat_long
global_size: 7 0 0

arg_out: 0 buffer long[28] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 -2 -2 -2 -2 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808  tolerance 0 
arg_in: 1 buffer long[28] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 32 32 32 32 -8 -8 -8 -8 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 
arg_in: 2 buffer long[28] 64 64 64 64 50 50 50 50 -32 -32 -32 -32 6 6 6 6 -63 -63 -63 -63 -12 -12 -12 -12 -50 -50 -50 -50 

[test]
name: add_sat long8
kernel_name: test_8_add_sat_long
global_size: 7 0 0

arg_out: 0 buffer long[56] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 0 0 0 0 -2 -2 -2 -2 -2 -2 -2 -2 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808  tolerance 0 
arg_in: 1 buffer long[56] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 32 32 32 32 32 32 32 32 -8 -8 -8 -8 -8 -8 -8 -8 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 
arg_in: 2 buffer long[56] 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 -32 -32 -32 -32 -32 -32 -32 -32 6 6 6 6 6 6 6 6 -63 -63 -63 -63 -63 -63 -63 -63 -12 -12 -12 -12 -12 -12 -12 -12 -50 -50 -50 -50 -50 -50 -50 -50 

[test]
name: add_sat long16
kernel_name: test_16_add_sat_long
global_size: 7 0 0

arg_out: 0 buffer long[112] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 9223372036854775744 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808  tolerance 0 
arg_in: 1 buffer long[112] 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 9223372036854775806 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 -9223372036854775798 
arg_in: 2 buffer long[112] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 

!*/

kernel void test_1_add_sat_long(global long* out, global long* in0, global long* in1){
  out[get_global_id(0)] = add_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_add_sat_long(global long* out, global long* in0, global long* in1){
  vstore2(add_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_add_sat_long(global long* out, global long* in0, global long* in1){
  vstore4(add_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_add_sat_long(global long* out, global long* in0, global long* in1){
  vstore8(add_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_add_sat_long(global long* out, global long* in0, global long* in1){
  vstore16(add_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

