/*!
[config]
name: Test long abs_diff built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs_diff long1
kernel_name: test_1_abs_diff_long
global_size: 7 0 0

arg_out: 0 buffer ulong[7] 0 1 1 18446744073709551615 18446744073709551615 1 15  tolerance 0 
arg_in: 1 buffer long[7] 0 1 0 -9223372036854775808 9223372036854775807 0 -8 
arg_in: 2 buffer long[7] 0 0 1 9223372036854775807 -9223372036854775808 1 7 

[test]
name: abs_diff long2
kernel_name: test_2_abs_diff_long
global_size: 7 0 0

arg_out: 0 buffer ulong[14] 0 0 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 15 15  tolerance 0 
arg_in: 1 buffer long[14] 0 0 1 1 0 0 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 0 0 -8 -8 
arg_in: 2 buffer long[14] 0 0 0 0 1 1 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 1 1 7 7 

[test]
name: abs_diff long4
kernel_name: test_4_abs_diff_long
global_size: 7 0 0

arg_out: 0 buffer ulong[28] 0 0 0 0 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 15 15 15 15  tolerance 0 
arg_in: 1 buffer long[28] 0 0 0 0 1 1 1 1 0 0 0 0 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 -8 -8 -8 -8 
arg_in: 2 buffer long[28] 0 0 0 0 0 0 0 0 1 1 1 1 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 1 1 1 1 7 7 7 7 

[test]
name: abs_diff long8
kernel_name: test_8_abs_diff_long
global_size: 7 0 0

arg_out: 0 buffer ulong[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer long[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer long[56] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 

[test]
name: abs_diff long16
kernel_name: test_16_abs_diff_long
global_size: 7 0 0

arg_out: 0 buffer ulong[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer long[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer long[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_abs_diff_long(global ulong* out, global long* in0, global long* in1){
  out[get_global_id(0)] = abs_diff(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_abs_diff_long(global ulong* out, global long* in0, global long* in1){
  vstore2(abs_diff(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_abs_diff_long(global ulong* out, global long* in0, global long* in1){
  vstore4(abs_diff(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_abs_diff_long(global ulong* out, global long* in0, global long* in1){
  vstore8(abs_diff(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_abs_diff_long(global ulong* out, global long* in0, global long* in1){
  vstore16(abs_diff(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

