/*!
[config]
name: Test long abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs long1
kernel_name: test_1_abs_long
global_size: 6 0 0

arg_out: 0 buffer ulong[6] 0 2 9223372036854775808 9223372036854775807 1 13  tolerance 0 
arg_in: 1 buffer long[6] 0 2 -9223372036854775808 9223372036854775807 -1 -13 

[test]
name: abs long2
kernel_name: test_2_abs_long
global_size: 6 0 0

arg_out: 0 buffer ulong[12] 0 0 2 2 9223372036854775808 9223372036854775808 9223372036854775807 9223372036854775807 1 1 13 13  tolerance 0 
arg_in: 1 buffer long[12] 0 0 2 2 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 -1 -1 -13 -13 

[test]
name: abs long4
kernel_name: test_4_abs_long
global_size: 6 0 0

arg_out: 0 buffer ulong[24] 0 0 0 0 2 2 2 2 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 1 1 1 1 13 13 13 13  tolerance 0 
arg_in: 1 buffer long[24] 0 0 0 0 2 2 2 2 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -1 -1 -1 -1 -13 -13 -13 -13 

[test]
name: abs long8
kernel_name: test_8_abs_long
global_size: 6 0 0

arg_out: 0 buffer ulong[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer long[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 

[test]
name: abs long16
kernel_name: test_16_abs_long
global_size: 6 0 0

arg_out: 0 buffer ulong[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer long[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 -9223372036854775808 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 

!*/

kernel void test_1_abs_long(global ulong* out, global long* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_long(global ulong* out, global long* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_long(global ulong* out, global long* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_long(global ulong* out, global long* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_long(global ulong* out, global long* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

