/*!
[config]
name: Test int upsample built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: upsample int1
kernel_name: test_1_upsample_int
global_size: 8 0 0

arg_out: 0 buffer long[8] 4294967296 4294967297 9223372036854775807 0 2147483647 4294967303 -1 -4294967296  tolerance 0 
arg_in: 1 buffer int[8] 1 1 2147483647 0 0 1 -1 -1 
arg_in: 2 buffer uint[8] 0 1 4294967295 0 2147483647 7 4294967295 0 

[test]
name: upsample int2
kernel_name: test_2_upsample_int
global_size: 8 0 0

arg_out: 0 buffer long[16] 4294967296 4294967296 4294967297 4294967297 9223372036854775807 9223372036854775807 0 0 2147483647 2147483647 4294967303 4294967303 -1 -1 -4294967296 -4294967296  tolerance 0 
arg_in: 1 buffer int[16] 1 1 1 1 2147483647 2147483647 0 0 0 0 1 1 -1 -1 -1 -1 
arg_in: 2 buffer uint[16] 0 0 1 1 4294967295 4294967295 0 0 2147483647 2147483647 7 7 4294967295 4294967295 0 0 

[test]
name: upsample int4
kernel_name: test_4_upsample_int
global_size: 8 0 0

arg_out: 0 buffer long[32] 4294967296 4294967296 4294967296 4294967296 4294967297 4294967297 4294967297 4294967297 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 2147483647 2147483647 2147483647 2147483647 4294967303 4294967303 4294967303 4294967303 -1 -1 -1 -1 -4294967296 -4294967296 -4294967296 -4294967296  tolerance 0 
arg_in: 1 buffer int[32] 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer uint[32] 0 0 0 0 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 2147483647 2147483647 2147483647 2147483647 7 7 7 7 4294967295 4294967295 4294967295 4294967295 0 0 0 0 

[test]
name: upsample int8
kernel_name: test_8_upsample_int
global_size: 8 0 0

arg_out: 0 buffer long[64] 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 -1 -1 -1 -1 -1 -1 -1 -1 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296  tolerance 0 
arg_in: 1 buffer int[64] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer uint[64] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 7 7 7 7 7 7 7 7 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 

[test]
name: upsample int16
kernel_name: test_16_upsample_int
global_size: 8 0 0

arg_out: 0 buffer long[128] 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 9223372036854775807 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296 -4294967296  tolerance 0 
arg_in: 1 buffer int[128] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer uint[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_upsample_int(global long* out, global int* in0, global uint* in1){
  out[get_global_id(0)] = upsample(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_upsample_int(global long* out, global int* in0, global uint* in1){
  vstore2(upsample(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_upsample_int(global long* out, global int* in0, global uint* in1){
  vstore4(upsample(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_upsample_int(global long* out, global int* in0, global uint* in1){
  vstore8(upsample(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_upsample_int(global long* out, global int* in0, global uint* in1){
  vstore16(upsample(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

