/*!
[config]
name: Test int rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate int1
kernel_name: test_1_rotate_int
global_size: 13 0 0

arg_out: 0 buffer int[13] 1 8 1 2 1 -2147483648 -2147483648 536870912 1 -2147483648 1073741824 -2147483648 2147483647  tolerance 0 
arg_in: 1 buffer int[13] 1 1 1 1 1 1 1 1 1 1 1 1 -2 
arg_in: 2 buffer int[13] 0 3 32 33 320 31 -1 -3 -32 -33 -34 31 -1 

[test]
name: rotate int2
kernel_name: test_2_rotate_int
global_size: 13 0 0

arg_out: 0 buffer int[26] 1 1 8 8 1 1 2 2 1 1 -2147483648 -2147483648 -2147483648 -2147483648 536870912 536870912 1 1 -2147483648 -2147483648 1073741824 1073741824 -2147483648 -2147483648 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer int[26] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 
arg_in: 2 buffer int[26] 0 0 3 3 32 32 33 33 320 320 31 31 -1 -1 -3 -3 -32 -32 -33 -33 -34 -34 31 31 -1 -1 

[test]
name: rotate int4
kernel_name: test_4_rotate_int
global_size: 13 0 0

arg_out: 0 buffer int[52] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 536870912 536870912 536870912 536870912 1 1 1 1 -2147483648 -2147483648 -2147483648 -2147483648 1073741824 1073741824 1073741824 1073741824 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer int[52] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 
arg_in: 2 buffer int[52] 0 0 0 0 3 3 3 3 32 32 32 32 33 33 33 33 320 320 320 320 31 31 31 31 -1 -1 -1 -1 -3 -3 -3 -3 -32 -32 -32 -32 -33 -33 -33 -33 -34 -34 -34 -34 31 31 31 31 -1 -1 -1 -1 

[test]
name: rotate int8
kernel_name: test_8_rotate_int
global_size: 13 0 0

arg_out: 0 buffer int[104] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 1 1 1 1 1 1 1 1 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer int[104] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 -2 -2 -2 -2 
arg_in: 2 buffer int[104] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 32 32 32 32 32 32 32 32 33 33 33 33 33 33 33 33 320 320 320 320 320 320 320 320 31 31 31 31 31 31 31 31 -1 -1 -1 -1 -1 -1 -1 -1 -3 -3 -3 -3 -3 -3 -3 -3 -32 -32 -32 -32 -32 -32 -32 -32 -33 -33 -33 -33 -33 -33 -33 -33 -34 -34 -34 -34 -34 -34 -34 -34 31 31 31 31 31 31 31 31 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: rotate int16
kernel_name: test_16_rotate_int
global_size: 13 0 0

arg_out: 0 buffer int[208] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 536870912 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 1073741824 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer int[208] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 
arg_in: 2 buffer int[208] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 320 320 320 320 320 320 320 320 320 320 320 320 320 320 320 320 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 -34 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

!*/

kernel void test_1_rotate_int(global int* out, global int* in0, global int* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_int(global int* out, global int* in0, global int* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_int(global int* out, global int* in0, global int* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_int(global int* out, global int* in0, global int* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_int(global int* out, global int* in0, global int* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

