/*!
[config]
name: Test int popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount int1
kernel_name: test_1_popcount_int
global_size: 5 0 0

arg_out: 0 buffer int[5] 1 2 0 31 1  tolerance 0 
arg_in: 1 buffer int[5] 1 3 0 2147483647 -2147483648 

[test]
name: popcount int2
kernel_name: test_2_popcount_int
global_size: 5 0 0

arg_out: 0 buffer int[10] 1 1 2 2 0 0 31 31 1 1  tolerance 0 
arg_in: 1 buffer int[10] 1 1 3 3 0 0 2147483647 2147483647 -2147483648 -2147483648 

[test]
name: popcount int4
kernel_name: test_4_popcount_int
global_size: 5 0 0

arg_out: 0 buffer int[20] 1 1 1 1 2 2 2 2 0 0 0 0 31 31 31 31 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[20] 1 1 1 1 3 3 3 3 0 0 0 0 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 

[test]
name: popcount int8
kernel_name: test_8_popcount_int
global_size: 5 0 0

arg_out: 0 buffer int[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 31 31 31 31 31 31 31 31 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 

[test]
name: popcount int16
kernel_name: test_16_popcount_int
global_size: 5 0 0

arg_out: 0 buffer int[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 

!*/

kernel void test_1_popcount_int(global int* out, global int* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_int(global int* out, global int* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_int(global int* out, global int* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_int(global int* out, global int* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_int(global int* out, global int* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

