/*!
[config]
name: Test int mul24 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mul24 int1
kernel_name: test_1_mul24_int
global_size: 5 0 0

arg_out: 0 buffer int[5] 0 1 1 512 4278190081  tolerance 0 
arg_in: 1 buffer int[5] 0 1 -1 32 8388607 
arg_in: 2 buffer int[5] 0 1 -1 16 8388607 

[test]
name: mul24 int2
kernel_name: test_2_mul24_int
global_size: 5 0 0

arg_out: 0 buffer int[10] 0 0 1 1 1 1 512 512 4278190081 4278190081  tolerance 0 
arg_in: 1 buffer int[10] 0 0 1 1 -1 -1 32 32 8388607 8388607 
arg_in: 2 buffer int[10] 0 0 1 1 -1 -1 16 16 8388607 8388607 

[test]
name: mul24 int4
kernel_name: test_4_mul24_int
global_size: 5 0 0

arg_out: 0 buffer int[20] 0 0 0 0 1 1 1 1 1 1 1 1 512 512 512 512 4278190081 4278190081 4278190081 4278190081  tolerance 0 
arg_in: 1 buffer int[20] 0 0 0 0 1 1 1 1 -1 -1 -1 -1 32 32 32 32 8388607 8388607 8388607 8388607 
arg_in: 2 buffer int[20] 0 0 0 0 1 1 1 1 -1 -1 -1 -1 16 16 16 16 8388607 8388607 8388607 8388607 

[test]
name: mul24 int8
kernel_name: test_8_mul24_int
global_size: 5 0 0

arg_out: 0 buffer int[40] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 512 512 512 512 512 512 512 512 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081  tolerance 0 
arg_in: 1 buffer int[40] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 32 32 32 32 32 32 32 32 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 
arg_in: 2 buffer int[40] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 16 16 16 16 16 16 16 16 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 

[test]
name: mul24 int16
kernel_name: test_16_mul24_int
global_size: 5 0 0

arg_out: 0 buffer int[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 512 512 512 512 512 512 512 512 512 512 512 512 512 512 512 512 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081  tolerance 0 
arg_in: 1 buffer int[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 
arg_in: 2 buffer int[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 8388607 

!*/

kernel void test_1_mul24_int(global int* out, global int* in0, global int* in1){
  out[get_global_id(0)] = mul24(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_mul24_int(global int* out, global int* in0, global int* in1){
  vstore2(mul24(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_mul24_int(global int* out, global int* in0, global int* in1){
  vstore4(mul24(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_mul24_int(global int* out, global int* in0, global int* in1){
  vstore8(mul24(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_mul24_int(global int* out, global int* in0, global int* in1){
  vstore16(mul24(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

