/*!
[config]
name: Test int max built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: max int1
kernel_name: test_1_max_int
global_size: 12 0 0

arg_out: 0 buffer int[12] 92 2 12 2147483647 1 2147483647 -2147483648 2147483647 2147483647 0 -1 1  tolerance 0 
arg_in: 1 buffer int[12] 92 2 12 2147483647 -2147483648 2147483647 -2147483648 -2147483648 2147483647 0 -1 1 
arg_in: 2 buffer int[12] 2 -2147483648 4 1 1 2147483647 -2147483648 2147483647 -2147483648 0 -2147483648 -1 

[test]
name: max int2
kernel_name: test_2_max_int
global_size: 12 0 0

arg_out: 0 buffer int[24] 92 92 2 2 12 12 2147483647 2147483647 1 1 2147483647 2147483647 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 0 0 -1 -1 1 1  tolerance 0 
arg_in: 1 buffer int[24] 92 92 2 2 12 12 2147483647 2147483647 -2147483648 -2147483648 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 0 0 -1 -1 1 1 
arg_in: 2 buffer int[24] 2 2 -2147483648 -2147483648 4 4 1 1 1 1 2147483647 2147483647 -2147483648 -2147483648 2147483647 2147483647 -2147483648 -2147483648 0 0 -2147483648 -2147483648 -1 -1 

[test]
name: tss_max int2
kernel_name: test_tss_2_max_int
global_size: 12 0 0

arg_out: 0 buffer int[24] 92 92 2 2 12 12 2147483647 2147483647 1 1 2147483647 2147483647 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 0 0 -1 -1 1 1  tolerance 0 
arg_in: 1 buffer int[24] 92 92 2 2 12 12 2147483647 2147483647 -2147483648 -2147483648 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 0 0 -1 -1 1 1 
arg_in: 2 buffer int[12] 2 -2147483648 4 1 1 2147483647 -2147483648 2147483647 -2147483648 0 -2147483648 -1

[test]
name: max int4
kernel_name: test_4_max_int
global_size: 12 0 0

arg_out: 0 buffer int[48] 92 92 92 92 2 2 2 2 12 12 12 12 2147483647 2147483647 2147483647 2147483647 1 1 1 1 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 -1 -1 -1 -1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[48] 92 92 92 92 2 2 2 2 12 12 12 12 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 0 0 0 0 -1 -1 -1 -1 1 1 1 1 
arg_in: 2 buffer int[48] 2 2 2 2 -2147483648 -2147483648 -2147483648 -2147483648 4 4 4 4 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 0 0 0 0 -2147483648 -2147483648 -2147483648 -2147483648 -1 -1 -1 -1 

[test]
name: tss_max int4
kernel_name: test_tss_4_max_int
global_size: 12 0 0

arg_out: 0 buffer int[48] 92 92 92 92 2 2 2 2 12 12 12 12 2147483647 2147483647 2147483647 2147483647 1 1 1 1 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 -1 -1 -1 -1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[48] 92 92 92 92 2 2 2 2 12 12 12 12 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 0 0 0 0 -1 -1 -1 -1 1 1 1 1 
arg_in: 2 buffer int[12] 2 -2147483648 4 1 1 2147483647 -2147483648 2147483647 -2147483648 0 -2147483648 -1

[test]
name: max int8
kernel_name: test_8_max_int
global_size: 12 0 0

arg_out: 0 buffer int[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer int[96] 2 2 2 2 2 2 2 2 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 0 0 0 0 0 0 0 0 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_max int8
kernel_name: test_tss_8_max_int
global_size: 12 0 0

arg_out: 0 buffer int[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer int[12] 2 -2147483648 4 1 1 2147483647 -2147483648 2147483647 -2147483648 0 -2147483648 -1

[test]
name: max int16
kernel_name: test_16_max_int
global_size: 12 0 0

arg_out: 0 buffer int[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer int[192] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_max int16
kernel_name: test_tss_16_max_int
global_size: 12 0 0

arg_out: 0 buffer int[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer int[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer int[12] 2 -2147483648 4 1 1 2147483647 -2147483648 2147483647 -2147483648 0 -2147483648 -1

!*/

kernel void test_1_max_int(global int* out, global int* in0, global int* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_int(global int* out, global int* in0, global int* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_int(global int* out, global int* in0, global int* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_int(global int* out, global int* in0, global int* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_int(global int* out, global int* in0, global int* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_int(global int* out, global int* in0, global int* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_int(global int* out, global int* in0, global int* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_int(global int* out, global int* in0, global int* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_int(global int* out, global int* in0, global int* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

