/*!
[config]
name: Test int mad24 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mad24 int1
kernel_name: test_1_mad24_int
global_size: 4 0 0

arg_out: 0 buffer int[4] 0 2 0 520  tolerance 0 
arg_in: 1 buffer int[4] 0 1 -1 32 
arg_in: 2 buffer int[4] 0 1 -1 16 
arg_in: 3 buffer int[4] 0 1 -1 8 

[test]
name: mad24 int2
kernel_name: test_2_mad24_int
global_size: 4 0 0

arg_out: 0 buffer int[8] 0 0 2 2 0 0 520 520  tolerance 0 
arg_in: 1 buffer int[8] 0 0 1 1 -1 -1 32 32 
arg_in: 2 buffer int[8] 0 0 1 1 -1 -1 16 16 
arg_in: 3 buffer int[8] 0 0 1 1 -1 -1 8 8 

[test]
name: mad24 int4
kernel_name: test_4_mad24_int
global_size: 4 0 0

arg_out: 0 buffer int[16] 0 0 0 0 2 2 2 2 0 0 0 0 520 520 520 520  tolerance 0 
arg_in: 1 buffer int[16] 0 0 0 0 1 1 1 1 -1 -1 -1 -1 32 32 32 32 
arg_in: 2 buffer int[16] 0 0 0 0 1 1 1 1 -1 -1 -1 -1 16 16 16 16 
arg_in: 3 buffer int[16] 0 0 0 0 1 1 1 1 -1 -1 -1 -1 8 8 8 8 

[test]
name: mad24 int8
kernel_name: test_8_mad24_int
global_size: 4 0 0

arg_out: 0 buffer int[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 520 520 520 520 520 520 520 520  tolerance 0 
arg_in: 1 buffer int[32] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 32 32 32 32 32 32 32 32 
arg_in: 2 buffer int[32] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 16 16 16 16 16 16 16 16 
arg_in: 3 buffer int[32] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 8 8 8 8 8 8 8 8 

[test]
name: mad24 int16
kernel_name: test_16_mad24_int
global_size: 4 0 0

arg_out: 0 buffer int[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 520 520 520 520 520 520 520 520 520 520 520 520 520 520 520 520  tolerance 0 
arg_in: 1 buffer int[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 
arg_in: 2 buffer int[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 
arg_in: 3 buffer int[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 

!*/

kernel void test_1_mad24_int(global int* out, global int* in0, global int* in1, global int* in2){
  out[get_global_id(0)] = mad24(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_mad24_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore2(mad24(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_mad24_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore4(mad24(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_mad24_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore8(mad24(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_mad24_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore16(mad24(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

