/*!
[config]
name: Test int hadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hadd int1
kernel_name: test_1_hadd_int
global_size: 7 0 0

arg_out: 0 buffer int[7] 32 0 10 2147483647 -2147483648 -1 -1  tolerance 0 
arg_in: 1 buffer int[7] 32 1 12 2147483647 -2147483648 2147483647 -2147483648 
arg_in: 2 buffer int[7] 33 0 8 2147483647 -2147483648 -2147483648 2147483647 

[test]
name: hadd int2
kernel_name: test_2_hadd_int
global_size: 7 0 0

arg_out: 0 buffer int[14] 32 32 0 0 10 10 2147483647 2147483647 -2147483648 -2147483648 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer int[14] 32 32 1 1 12 12 2147483647 2147483647 -2147483648 -2147483648 2147483647 2147483647 -2147483648 -2147483648 
arg_in: 2 buffer int[14] 33 33 0 0 8 8 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 

[test]
name: hadd int4
kernel_name: test_4_hadd_int
global_size: 7 0 0

arg_out: 0 buffer int[28] 32 32 32 32 0 0 0 0 10 10 10 10 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer int[28] 32 32 32 32 1 1 1 1 12 12 12 12 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 
arg_in: 2 buffer int[28] 33 33 33 33 0 0 0 0 8 8 8 8 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 

[test]
name: hadd int8
kernel_name: test_8_hadd_int
global_size: 7 0 0

arg_out: 0 buffer int[56] 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer int[56] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 
arg_in: 2 buffer int[56] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 

[test]
name: hadd int16
kernel_name: test_16_hadd_int
global_size: 7 0 0

arg_out: 0 buffer int[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer int[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 
arg_in: 2 buffer int[112] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 

!*/

kernel void test_1_hadd_int(global int* out, global int* in0, global int* in1){
  out[get_global_id(0)] = hadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hadd_int(global int* out, global int* in0, global int* in1){
  vstore2(hadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hadd_int(global int* out, global int* in0, global int* in1){
  vstore4(hadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hadd_int(global int* out, global int* in0, global int* in1){
  vstore8(hadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hadd_int(global int* out, global int* in0, global int* in1){
  vstore16(hadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

