/*!
[config]
name: Test int clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz int1
kernel_name: test_1_clz_int
global_size: 5 0 0

arg_out: 0 buffer int[5] 31 25 32 1 0  tolerance 0 
arg_in: 1 buffer int[5] 1 64 0 2147483647 -2147483648 

[test]
name: clz int2
kernel_name: test_2_clz_int
global_size: 5 0 0

arg_out: 0 buffer int[10] 31 31 25 25 32 32 1 1 0 0  tolerance 0 
arg_in: 1 buffer int[10] 1 1 64 64 0 0 2147483647 2147483647 -2147483648 -2147483648 

[test]
name: clz int4
kernel_name: test_4_clz_int
global_size: 5 0 0

arg_out: 0 buffer int[20] 31 31 31 31 25 25 25 25 32 32 32 32 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[20] 1 1 1 1 64 64 64 64 0 0 0 0 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 

[test]
name: clz int8
kernel_name: test_8_clz_int
global_size: 5 0 0

arg_out: 0 buffer int[40] 31 31 31 31 31 31 31 31 25 25 25 25 25 25 25 25 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 

[test]
name: clz int16
kernel_name: test_16_clz_int
global_size: 5 0 0

arg_out: 0 buffer int[80] 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 

!*/

kernel void test_1_clz_int(global int* out, global int* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_int(global int* out, global int* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_int(global int* out, global int* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_int(global int* out, global int* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_int(global int* out, global int* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

