/*!
[config]
name: Test int clamp built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: clamp int1
kernel_name: test_1_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[5] 64 -1073741824 1 -64 0  tolerance 0 
arg_in: 1 buffer int[5] 92 -2147483648 64 -128 -1 
arg_in: 2 buffer int[5] 0 -1073741824 0 -64 0 
arg_in: 3 buffer int[5] 64 0 1 0 1 

[test]
name: clamp int2
kernel_name: test_2_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[10] 64 64 -1073741824 -1073741824 1 1 -64 -64 0 0  tolerance 0 
arg_in: 1 buffer int[10] 92 92 -2147483648 -2147483648 64 64 -128 -128 -1 -1 
arg_in: 2 buffer int[10] 0 0 -1073741824 -1073741824 0 0 -64 -64 0 0 
arg_in: 3 buffer int[10] 64 64 0 0 1 1 0 0 1 1 

[test]
name: tss_clamp int2
kernel_name: test_tss_2_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[10] 64 64 -1073741824 -1073741824 1 1 -64 -64 0 0  tolerance 0 
arg_in: 1 buffer int[10] 92 92 -2147483648 -2147483648 64 64 -128 -128 -1 -1 
arg_in: 2 buffer int[5] 0 -1073741824 0 -64 0
arg_in: 3 buffer int[5] 64 0 1 0 1

[test]
name: clamp int4
kernel_name: test_4_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[20] 64 64 64 64 -1073741824 -1073741824 -1073741824 -1073741824 1 1 1 1 -64 -64 -64 -64 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[20] 92 92 92 92 -2147483648 -2147483648 -2147483648 -2147483648 64 64 64 64 -128 -128 -128 -128 -1 -1 -1 -1 
arg_in: 2 buffer int[20] 0 0 0 0 -1073741824 -1073741824 -1073741824 -1073741824 0 0 0 0 -64 -64 -64 -64 0 0 0 0 
arg_in: 3 buffer int[20] 64 64 64 64 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 

[test]
name: tss_clamp int4
kernel_name: test_tss_4_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[20] 64 64 64 64 -1073741824 -1073741824 -1073741824 -1073741824 1 1 1 1 -64 -64 -64 -64 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[20] 92 92 92 92 -2147483648 -2147483648 -2147483648 -2147483648 64 64 64 64 -128 -128 -128 -128 -1 -1 -1 -1 
arg_in: 2 buffer int[5] 0 -1073741824 0 -64 0
arg_in: 3 buffer int[5] 64 0 1 0 1

[test]
name: clamp int8
kernel_name: test_8_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[40] 64 64 64 64 64 64 64 64 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[40] 92 92 92 92 92 92 92 92 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer int[40] 0 0 0 0 0 0 0 0 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 
arg_in: 3 buffer int[40] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp int8
kernel_name: test_tss_8_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[40] 64 64 64 64 64 64 64 64 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[40] 92 92 92 92 92 92 92 92 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer int[5] 0 -1073741824 0 -64 0
arg_in: 3 buffer int[5] 64 0 1 0 1

[test]
name: clamp int16
kernel_name: test_16_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[80] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer int[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer int[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp int16
kernel_name: test_tss_16_clamp_int
global_size: 5 0 0

arg_out: 0 buffer int[80] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 -1073741824 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer int[80] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer int[5] 0 -1073741824 0 -64 0
arg_in: 3 buffer int[5] 64 0 1 0 1

!*/

kernel void test_1_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  out[get_global_id(0)] = clamp(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_clamp_int(global int* out, global int* in0, global int* in1, global int* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

