/*!
[config]
name: Test int add_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: add_sat int1
kernel_name: test_1_add_sat_int
global_size: 7 0 0

arg_out: 0 buffer int[7] 2147483647 2147483647 0 -2 2147483584 -2147483648 -2147483648  tolerance 0 
arg_in: 1 buffer int[7] 2147483647 2147483646 32 -8 2147483647 -2147483648 -2147483638 
arg_in: 2 buffer int[7] 64 50 -32 6 -63 -12 -50 

[test]
name: add_sat int2
kernel_name: test_2_add_sat_int
global_size: 7 0 0

arg_out: 0 buffer int[14] 2147483647 2147483647 2147483647 2147483647 0 0 -2 -2 2147483584 2147483584 -2147483648 -2147483648 -2147483648 -2147483648  tolerance 0 
arg_in: 1 buffer int[14] 2147483647 2147483647 2147483646 2147483646 32 32 -8 -8 2147483647 2147483647 -2147483648 -2147483648 -2147483638 -2147483638 
arg_in: 2 buffer int[14] 64 64 50 50 -32 -32 6 6 -63 -63 -12 -12 -50 -50 

[test]
name: add_sat int4
kernel_name: test_4_add_sat_int
global_size: 7 0 0

arg_out: 0 buffer int[28] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 -2 -2 -2 -2 2147483584 2147483584 2147483584 2147483584 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648  tolerance 0 
arg_in: 1 buffer int[28] 2147483647 2147483647 2147483647 2147483647 2147483646 2147483646 2147483646 2147483646 32 32 32 32 -8 -8 -8 -8 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483638 -2147483638 -2147483638 -2147483638 
arg_in: 2 buffer int[28] 64 64 64 64 50 50 50 50 -32 -32 -32 -32 6 6 6 6 -63 -63 -63 -63 -12 -12 -12 -12 -50 -50 -50 -50 

[test]
name: add_sat int8
kernel_name: test_8_add_sat_int
global_size: 7 0 0

arg_out: 0 buffer int[56] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 -2 -2 -2 -2 -2 -2 -2 -2 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648  tolerance 0 
arg_in: 1 buffer int[56] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 32 32 32 32 32 32 32 32 -8 -8 -8 -8 -8 -8 -8 -8 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 
arg_in: 2 buffer int[56] 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 -32 -32 -32 -32 -32 -32 -32 -32 6 6 6 6 6 6 6 6 -63 -63 -63 -63 -63 -63 -63 -63 -12 -12 -12 -12 -12 -12 -12 -12 -50 -50 -50 -50 -50 -50 -50 -50 

[test]
name: add_sat int16
kernel_name: test_16_add_sat_int
global_size: 7 0 0

arg_out: 0 buffer int[112] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 2147483584 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648  tolerance 0 
arg_in: 1 buffer int[112] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 2147483646 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 -2147483638 
arg_in: 2 buffer int[112] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 

!*/

kernel void test_1_add_sat_int(global int* out, global int* in0, global int* in1){
  out[get_global_id(0)] = add_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_add_sat_int(global int* out, global int* in0, global int* in1){
  vstore2(add_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_add_sat_int(global int* out, global int* in0, global int* in1){
  vstore4(add_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_add_sat_int(global int* out, global int* in0, global int* in1){
  vstore8(add_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_add_sat_int(global int* out, global int* in0, global int* in1){
  vstore16(add_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

