/*!
[config]
name: Test int abs_diff built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs_diff int1
kernel_name: test_1_abs_diff_int
global_size: 7 0 0

arg_out: 0 buffer uint[7] 0 1 1 4294967295 4294967295 1 15  tolerance 0 
arg_in: 1 buffer int[7] 0 1 0 -2147483648 2147483647 0 -8 
arg_in: 2 buffer int[7] 0 0 1 2147483647 -2147483648 1 7 

[test]
name: abs_diff int2
kernel_name: test_2_abs_diff_int
global_size: 7 0 0

arg_out: 0 buffer uint[14] 0 0 1 1 1 1 4294967295 4294967295 4294967295 4294967295 1 1 15 15  tolerance 0 
arg_in: 1 buffer int[14] 0 0 1 1 0 0 -2147483648 -2147483648 2147483647 2147483647 0 0 -8 -8 
arg_in: 2 buffer int[14] 0 0 0 0 1 1 2147483647 2147483647 -2147483648 -2147483648 1 1 7 7 

[test]
name: abs_diff int4
kernel_name: test_4_abs_diff_int
global_size: 7 0 0

arg_out: 0 buffer uint[28] 0 0 0 0 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 1 1 1 1 15 15 15 15  tolerance 0 
arg_in: 1 buffer int[28] 0 0 0 0 1 1 1 1 0 0 0 0 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 0 0 0 0 -8 -8 -8 -8 
arg_in: 2 buffer int[28] 0 0 0 0 0 0 0 0 1 1 1 1 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 1 1 1 1 7 7 7 7 

[test]
name: abs_diff int8
kernel_name: test_8_abs_diff_int
global_size: 7 0 0

arg_out: 0 buffer uint[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer int[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer int[56] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 

[test]
name: abs_diff int16
kernel_name: test_16_abs_diff_int
global_size: 7 0 0

arg_out: 0 buffer uint[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer int[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer int[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_abs_diff_int(global uint* out, global int* in0, global int* in1){
  out[get_global_id(0)] = abs_diff(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_abs_diff_int(global uint* out, global int* in0, global int* in1){
  vstore2(abs_diff(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_abs_diff_int(global uint* out, global int* in0, global int* in1){
  vstore4(abs_diff(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_abs_diff_int(global uint* out, global int* in0, global int* in1){
  vstore8(abs_diff(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_abs_diff_int(global uint* out, global int* in0, global int* in1){
  vstore16(abs_diff(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

