/*!
[config]
name: Test int abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs int1
kernel_name: test_1_abs_int
global_size: 6 0 0

arg_out: 0 buffer uint[6] 0 2 2147483648 2147483647 1 13  tolerance 0 
arg_in: 1 buffer int[6] 0 2 -2147483648 2147483647 -1 -13 

[test]
name: abs int2
kernel_name: test_2_abs_int
global_size: 6 0 0

arg_out: 0 buffer uint[12] 0 0 2 2 2147483648 2147483648 2147483647 2147483647 1 1 13 13  tolerance 0 
arg_in: 1 buffer int[12] 0 0 2 2 -2147483648 -2147483648 2147483647 2147483647 -1 -1 -13 -13 

[test]
name: abs int4
kernel_name: test_4_abs_int
global_size: 6 0 0

arg_out: 0 buffer uint[24] 0 0 0 0 2 2 2 2 2147483648 2147483648 2147483648 2147483648 2147483647 2147483647 2147483647 2147483647 1 1 1 1 13 13 13 13  tolerance 0 
arg_in: 1 buffer int[24] 0 0 0 0 2 2 2 2 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 -1 -1 -1 -1 -13 -13 -13 -13 

[test]
name: abs int8
kernel_name: test_8_abs_int
global_size: 6 0 0

arg_out: 0 buffer uint[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer int[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 

[test]
name: abs int16
kernel_name: test_16_abs_int
global_size: 6 0 0

arg_out: 0 buffer uint[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer int[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 -2147483648 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 

!*/

kernel void test_1_abs_int(global uint* out, global int* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_int(global uint* out, global int* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_int(global uint* out, global int* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_int(global uint* out, global int* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_int(global uint* out, global int* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

