/*!
[config]
name: Test char upsample built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: upsample char1
kernel_name: test_1_upsample_char
global_size: 8 0 0

arg_out: 0 buffer short[8] 256 257 32767 0 127 263 -1 -256  tolerance 0 
arg_in: 1 buffer char[8] 1 1 127 0 0 1 -1 -1 
arg_in: 2 buffer uchar[8] 0 1 255 0 127 7 255 0 

[test]
name: upsample char2
kernel_name: test_2_upsample_char
global_size: 8 0 0

arg_out: 0 buffer short[16] 256 256 257 257 32767 32767 0 0 127 127 263 263 -1 -1 -256 -256  tolerance 0 
arg_in: 1 buffer char[16] 1 1 1 1 127 127 0 0 0 0 1 1 -1 -1 -1 -1 
arg_in: 2 buffer uchar[16] 0 0 1 1 255 255 0 0 127 127 7 7 255 255 0 0 

[test]
name: upsample char4
kernel_name: test_4_upsample_char
global_size: 8 0 0

arg_out: 0 buffer short[32] 256 256 256 256 257 257 257 257 32767 32767 32767 32767 0 0 0 0 127 127 127 127 263 263 263 263 -1 -1 -1 -1 -256 -256 -256 -256  tolerance 0 
arg_in: 1 buffer char[32] 1 1 1 1 1 1 1 1 127 127 127 127 0 0 0 0 0 0 0 0 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer uchar[32] 0 0 0 0 1 1 1 1 255 255 255 255 0 0 0 0 127 127 127 127 7 7 7 7 255 255 255 255 0 0 0 0 

[test]
name: upsample char8
kernel_name: test_8_upsample_char
global_size: 8 0 0

arg_out: 0 buffer short[64] 256 256 256 256 256 256 256 256 257 257 257 257 257 257 257 257 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 263 263 263 263 263 263 263 263 -1 -1 -1 -1 -1 -1 -1 -1 -256 -256 -256 -256 -256 -256 -256 -256  tolerance 0 
arg_in: 1 buffer char[64] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer uchar[64] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 7 7 7 7 7 7 7 7 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 

[test]
name: upsample char16
kernel_name: test_16_upsample_char
global_size: 8 0 0

arg_out: 0 buffer short[128] 256 256 256 256 256 256 256 256 256 256 256 256 256 256 256 256 257 257 257 257 257 257 257 257 257 257 257 257 257 257 257 257 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 263 263 263 263 263 263 263 263 263 263 263 263 263 263 263 263 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256 -256  tolerance 0 
arg_in: 1 buffer char[128] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer uchar[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_upsample_char(global short* out, global char* in0, global uchar* in1){
  out[get_global_id(0)] = upsample(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_upsample_char(global short* out, global char* in0, global uchar* in1){
  vstore2(upsample(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_upsample_char(global short* out, global char* in0, global uchar* in1){
  vstore4(upsample(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_upsample_char(global short* out, global char* in0, global uchar* in1){
  vstore8(upsample(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_upsample_char(global short* out, global char* in0, global uchar* in1){
  vstore16(upsample(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

