/*!
[config]
name: Test char rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate char1
kernel_name: test_1_rotate_char
global_size: 13 0 0

arg_out: 0 buffer char[13] 1 8 1 2 1 -128 -128 32 1 -128 64 -128 127  tolerance 0 
arg_in: 1 buffer char[13] 1 1 1 1 1 1 1 1 1 1 1 1 -2 
arg_in: 2 buffer char[13] 0 3 8 9 80 7 -1 -3 -8 -9 -10 7 -1 

[test]
name: rotate char2
kernel_name: test_2_rotate_char
global_size: 13 0 0

arg_out: 0 buffer char[26] 1 1 8 8 1 1 2 2 1 1 -128 -128 -128 -128 32 32 1 1 -128 -128 64 64 -128 -128 127 127  tolerance 0 
arg_in: 1 buffer char[26] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 
arg_in: 2 buffer char[26] 0 0 3 3 8 8 9 9 80 80 7 7 -1 -1 -3 -3 -8 -8 -9 -9 -10 -10 7 7 -1 -1 

[test]
name: rotate char4
kernel_name: test_4_rotate_char
global_size: 13 0 0

arg_out: 0 buffer char[52] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 32 32 32 32 1 1 1 1 -128 -128 -128 -128 64 64 64 64 -128 -128 -128 -128 127 127 127 127  tolerance 0 
arg_in: 1 buffer char[52] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 
arg_in: 2 buffer char[52] 0 0 0 0 3 3 3 3 8 8 8 8 9 9 9 9 80 80 80 80 7 7 7 7 -1 -1 -1 -1 -3 -3 -3 -3 -8 -8 -8 -8 -9 -9 -9 -9 -10 -10 -10 -10 7 7 7 7 -1 -1 -1 -1 

[test]
name: rotate char8
kernel_name: test_8_rotate_char
global_size: 13 0 0

arg_out: 0 buffer char[104] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127  tolerance 0 
arg_in: 1 buffer char[104] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 -2 -2 -2 -2 
arg_in: 2 buffer char[104] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 8 8 8 8 8 8 8 8 9 9 9 9 9 9 9 9 80 80 80 80 80 80 80 80 7 7 7 7 7 7 7 7 -1 -1 -1 -1 -1 -1 -1 -1 -3 -3 -3 -3 -3 -3 -3 -3 -8 -8 -8 -8 -8 -8 -8 -8 -9 -9 -9 -9 -9 -9 -9 -9 -10 -10 -10 -10 -10 -10 -10 -10 7 7 7 7 7 7 7 7 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: rotate char16
kernel_name: test_16_rotate_char
global_size: 13 0 0

arg_out: 0 buffer char[208] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127  tolerance 0 
arg_in: 1 buffer char[208] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 
arg_in: 2 buffer char[208] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 -10 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

!*/

kernel void test_1_rotate_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_char(global char* out, global char* in0, global char* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_char(global char* out, global char* in0, global char* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_char(global char* out, global char* in0, global char* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_char(global char* out, global char* in0, global char* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

