/*!
[config]
name: Test char rhadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rhadd char1
kernel_name: test_1_rhadd_char
global_size: 4 0 0

arg_out: 0 buffer char[4] 33 1 10 -32  tolerance 0 
arg_in: 1 buffer char[4] 32 1 12 -33 
arg_in: 2 buffer char[4] 33 0 8 -32 

[test]
name: rhadd char2
kernel_name: test_2_rhadd_char
global_size: 4 0 0

arg_out: 0 buffer char[8] 33 33 1 1 10 10 -32 -32  tolerance 0 
arg_in: 1 buffer char[8] 32 32 1 1 12 12 -33 -33 
arg_in: 2 buffer char[8] 33 33 0 0 8 8 -32 -32 

[test]
name: rhadd char4
kernel_name: test_4_rhadd_char
global_size: 4 0 0

arg_out: 0 buffer char[16] 33 33 33 33 1 1 1 1 10 10 10 10 -32 -32 -32 -32  tolerance 0 
arg_in: 1 buffer char[16] 32 32 32 32 1 1 1 1 12 12 12 12 -33 -33 -33 -33 
arg_in: 2 buffer char[16] 33 33 33 33 0 0 0 0 8 8 8 8 -32 -32 -32 -32 

[test]
name: rhadd char8
kernel_name: test_8_rhadd_char
global_size: 4 0 0

arg_out: 0 buffer char[32] 33 33 33 33 33 33 33 33 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 -32 -32 -32 -32 -32 -32 -32 -32  tolerance 0 
arg_in: 1 buffer char[32] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 -33 -33 -33 -33 -33 -33 -33 -33 
arg_in: 2 buffer char[32] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 -32 -32 -32 -32 -32 -32 -32 -32 

[test]
name: rhadd char16
kernel_name: test_16_rhadd_char
global_size: 4 0 0

arg_out: 0 buffer char[64] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32  tolerance 0 
arg_in: 1 buffer char[64] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 -33 
arg_in: 2 buffer char[64] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 

!*/

kernel void test_1_rhadd_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = rhadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rhadd_char(global char* out, global char* in0, global char* in1){
  vstore2(rhadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rhadd_char(global char* out, global char* in0, global char* in1){
  vstore4(rhadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rhadd_char(global char* out, global char* in0, global char* in1){
  vstore8(rhadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rhadd_char(global char* out, global char* in0, global char* in1){
  vstore16(rhadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

