/*!
[config]
name: Test char popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount char1
kernel_name: test_1_popcount_char
global_size: 5 0 0

arg_out: 0 buffer char[5] 1 2 0 7 1  tolerance 0 
arg_in: 1 buffer char[5] 1 3 0 127 -128 

[test]
name: popcount char2
kernel_name: test_2_popcount_char
global_size: 5 0 0

arg_out: 0 buffer char[10] 1 1 2 2 0 0 7 7 1 1  tolerance 0 
arg_in: 1 buffer char[10] 1 1 3 3 0 0 127 127 -128 -128 

[test]
name: popcount char4
kernel_name: test_4_popcount_char
global_size: 5 0 0

arg_out: 0 buffer char[20] 1 1 1 1 2 2 2 2 0 0 0 0 7 7 7 7 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[20] 1 1 1 1 3 3 3 3 0 0 0 0 127 127 127 127 -128 -128 -128 -128 

[test]
name: popcount char8
kernel_name: test_8_popcount_char
global_size: 5 0 0

arg_out: 0 buffer char[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 7 7 7 7 7 7 7 7 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 

[test]
name: popcount char16
kernel_name: test_16_popcount_char
global_size: 5 0 0

arg_out: 0 buffer char[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 

!*/

kernel void test_1_popcount_char(global char* out, global char* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_char(global char* out, global char* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_char(global char* out, global char* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_char(global char* out, global char* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_char(global char* out, global char* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

