/*!
[config]
name: Test char mul_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mul_hi char1
kernel_name: test_1_mul_hi_char
global_size: 12 0 0

arg_out: 0 buffer char[12] 0 0 0 63 64 0 0 -64 0 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[12] 0 92 127 127 -128 92 127 -128 -1 -128 -128 1 
arg_in: 2 buffer char[12] 0 2 1 127 -128 1 2 127 -128 2 1 -1 

[test]
name: mul_hi char2
kernel_name: test_2_mul_hi_char
global_size: 12 0 0

arg_out: 0 buffer char[24] 0 0 0 0 0 0 63 63 64 64 0 0 0 0 -64 -64 0 0 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[24] 0 0 92 92 127 127 127 127 -128 -128 92 92 127 127 -128 -128 -1 -1 -128 -128 -128 -128 1 1 
arg_in: 2 buffer char[24] 0 0 2 2 1 1 127 127 -128 -128 1 1 2 2 127 127 -128 -128 2 2 1 1 -1 -1 

[test]
name: mul_hi char4
kernel_name: test_4_mul_hi_char
global_size: 12 0 0

arg_out: 0 buffer char[48] 0 0 0 0 0 0 0 0 0 0 0 0 63 63 63 63 64 64 64 64 0 0 0 0 0 0 0 0 -64 -64 -64 -64 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[48] 0 0 0 0 92 92 92 92 127 127 127 127 127 127 127 127 -128 -128 -128 -128 92 92 92 92 127 127 127 127 -128 -128 -128 -128 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 
arg_in: 2 buffer char[48] 0 0 0 0 2 2 2 2 1 1 1 1 127 127 127 127 -128 -128 -128 -128 1 1 1 1 2 2 2 2 127 127 127 127 -128 -128 -128 -128 2 2 2 2 1 1 1 1 -1 -1 -1 -1 

[test]
name: mul_hi char8
kernel_name: test_8_mul_hi_char
global_size: 12 0 0

arg_out: 0 buffer char[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 63 63 63 63 63 63 63 63 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[96] 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 92 92 92 92 92 92 92 92 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 1 1 1 1 
arg_in: 2 buffer char[96] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: mul_hi char16
kernel_name: test_16_mul_hi_char
global_size: 12 0 0

arg_out: 0 buffer char[192] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[192] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer char[192] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

!*/

kernel void test_1_mul_hi_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = mul_hi(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_mul_hi_char(global char* out, global char* in0, global char* in1){
  vstore2(mul_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_mul_hi_char(global char* out, global char* in0, global char* in1){
  vstore4(mul_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_mul_hi_char(global char* out, global char* in0, global char* in1){
  vstore8(mul_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_mul_hi_char(global char* out, global char* in0, global char* in1){
  vstore16(mul_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

