/*!
[config]
name: Test char min built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: min char1
kernel_name: test_1_min_char
global_size: 14 0 0

arg_out: 0 buffer char[14] 2 1 -128 4 1 -128 127 -128 -128 0 127 -128 -1 -128  tolerance 0 
arg_in: 1 buffer char[14] 92 64 2 12 127 -128 127 -128 -128 0 127 -1 1 -128 
arg_in: 2 buffer char[14] 2 1 -128 4 1 1 127 -128 127 0 127 -128 -1 -1 

[test]
name: min char2
kernel_name: test_2_min_char
global_size: 14 0 0

arg_out: 0 buffer char[28] 2 2 1 1 -128 -128 4 4 1 1 -128 -128 127 127 -128 -128 -128 -128 0 0 127 127 -128 -128 -1 -1 -128 -128  tolerance 0 
arg_in: 1 buffer char[28] 92 92 64 64 2 2 12 12 127 127 -128 -128 127 127 -128 -128 -128 -128 0 0 127 127 -1 -1 1 1 -128 -128 
arg_in: 2 buffer char[28] 2 2 1 1 -128 -128 4 4 1 1 1 1 127 127 -128 -128 127 127 0 0 127 127 -128 -128 -1 -1 -1 -1 

[test]
name: tss_min char2
kernel_name: test_tss_2_min_char
global_size: 14 0 0

arg_out: 0 buffer char[28] 2 2 1 1 -128 -128 4 4 1 1 -128 -128 127 127 -128 -128 -128 -128 0 0 127 127 -128 -128 -1 -1 -128 -128  tolerance 0 
arg_in: 1 buffer char[28] 92 92 64 64 2 2 12 12 127 127 -128 -128 127 127 -128 -128 -128 -128 0 0 127 127 -1 -1 1 1 -128 -128 
arg_in: 2 buffer char[14] 2 1 -128 4 1 1 127 -128 127 0 127 -128 -1 -1

[test]
name: min char4
kernel_name: test_4_min_char
global_size: 14 0 0

arg_out: 0 buffer char[56] 2 2 2 2 1 1 1 1 -128 -128 -128 -128 4 4 4 4 1 1 1 1 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 127 127 127 127 -128 -128 -128 -128 -1 -1 -1 -1 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[56] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 127 127 127 127 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 127 127 127 127 -1 -1 -1 -1 1 1 1 1 -128 -128 -128 -128 
arg_in: 2 buffer char[56] 2 2 2 2 1 1 1 1 -128 -128 -128 -128 4 4 4 4 1 1 1 1 1 1 1 1 127 127 127 127 -128 -128 -128 -128 127 127 127 127 0 0 0 0 127 127 127 127 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_min char4
kernel_name: test_tss_4_min_char
global_size: 14 0 0

arg_out: 0 buffer char[56] 2 2 2 2 1 1 1 1 -128 -128 -128 -128 4 4 4 4 1 1 1 1 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 127 127 127 127 -128 -128 -128 -128 -1 -1 -1 -1 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[56] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 127 127 127 127 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 127 127 127 127 -1 -1 -1 -1 1 1 1 1 -128 -128 -128 -128 
arg_in: 2 buffer char[14] 2 1 -128 4 1 1 127 -128 127 0 127 -128 -1 -1

[test]
name: min char8
kernel_name: test_8_min_char
global_size: 14 0 0

arg_out: 0 buffer char[112] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[112] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 
arg_in: 2 buffer char[112] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_min char8
kernel_name: test_tss_8_min_char
global_size: 14 0 0

arg_out: 0 buffer char[112] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[112] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 
arg_in: 2 buffer char[14] 2 1 -128 4 1 1 127 -128 127 0 127 -128 -1 -1

[test]
name: min char16
kernel_name: test_16_min_char
global_size: 14 0 0

arg_out: 0 buffer char[224] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[224] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 
arg_in: 2 buffer char[224] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_min char16
kernel_name: test_tss_16_min_char
global_size: 14 0 0

arg_out: 0 buffer char[224] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[224] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 
arg_in: 2 buffer char[14] 2 1 -128 4 1 1 127 -128 127 0 127 -128 -1 -1

!*/

kernel void test_1_min_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = min(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_min_char(global char* out, global char* in0, global char* in1){
  vstore2(min(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_min_char(global char* out, global char* in0, global char* in1){
  vstore4(min(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_min_char(global char* out, global char* in0, global char* in1){
  vstore8(min(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_min_char(global char* out, global char* in0, global char* in1){
  vstore16(min(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_min_char(global char* out, global char* in0, global char* in1){
  vstore2(min(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_min_char(global char* out, global char* in0, global char* in1){
  vstore4(min(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_min_char(global char* out, global char* in0, global char* in1){
  vstore8(min(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_min_char(global char* out, global char* in0, global char* in1){
  vstore16(min(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

