/*!
[config]
name: Test char max built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: max char1
kernel_name: test_1_max_char
global_size: 12 0 0

arg_out: 0 buffer char[12] 92 2 12 127 1 127 -128 127 127 0 -1 1  tolerance 0 
arg_in: 1 buffer char[12] 92 2 12 127 -128 127 -128 -128 127 0 -1 1 
arg_in: 2 buffer char[12] 2 -128 4 1 1 127 -128 127 -128 0 -128 -1 

[test]
name: max char2
kernel_name: test_2_max_char
global_size: 12 0 0

arg_out: 0 buffer char[24] 92 92 2 2 12 12 127 127 1 1 127 127 -128 -128 127 127 127 127 0 0 -1 -1 1 1  tolerance 0 
arg_in: 1 buffer char[24] 92 92 2 2 12 12 127 127 -128 -128 127 127 -128 -128 -128 -128 127 127 0 0 -1 -1 1 1 
arg_in: 2 buffer char[24] 2 2 -128 -128 4 4 1 1 1 1 127 127 -128 -128 127 127 -128 -128 0 0 -128 -128 -1 -1 

[test]
name: tss_max char2
kernel_name: test_tss_2_max_char
global_size: 12 0 0

arg_out: 0 buffer char[24] 92 92 2 2 12 12 127 127 1 1 127 127 -128 -128 127 127 127 127 0 0 -1 -1 1 1  tolerance 0 
arg_in: 1 buffer char[24] 92 92 2 2 12 12 127 127 -128 -128 127 127 -128 -128 -128 -128 127 127 0 0 -1 -1 1 1 
arg_in: 2 buffer char[12] 2 -128 4 1 1 127 -128 127 -128 0 -128 -1

[test]
name: max char4
kernel_name: test_4_max_char
global_size: 12 0 0

arg_out: 0 buffer char[48] 92 92 92 92 2 2 2 2 12 12 12 12 127 127 127 127 1 1 1 1 127 127 127 127 -128 -128 -128 -128 127 127 127 127 127 127 127 127 0 0 0 0 -1 -1 -1 -1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[48] 92 92 92 92 2 2 2 2 12 12 12 12 127 127 127 127 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 0 0 0 0 -1 -1 -1 -1 1 1 1 1 
arg_in: 2 buffer char[48] 2 2 2 2 -128 -128 -128 -128 4 4 4 4 1 1 1 1 1 1 1 1 127 127 127 127 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 0 0 0 0 -128 -128 -128 -128 -1 -1 -1 -1 

[test]
name: tss_max char4
kernel_name: test_tss_4_max_char
global_size: 12 0 0

arg_out: 0 buffer char[48] 92 92 92 92 2 2 2 2 12 12 12 12 127 127 127 127 1 1 1 1 127 127 127 127 -128 -128 -128 -128 127 127 127 127 127 127 127 127 0 0 0 0 -1 -1 -1 -1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[48] 92 92 92 92 2 2 2 2 12 12 12 12 127 127 127 127 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 0 0 0 0 -1 -1 -1 -1 1 1 1 1 
arg_in: 2 buffer char[12] 2 -128 4 1 1 127 -128 127 -128 0 -128 -1

[test]
name: max char8
kernel_name: test_8_max_char
global_size: 12 0 0

arg_out: 0 buffer char[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer char[96] 2 2 2 2 2 2 2 2 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_max char8
kernel_name: test_tss_8_max_char
global_size: 12 0 0

arg_out: 0 buffer char[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer char[12] 2 -128 4 1 1 127 -128 127 -128 0 -128 -1

[test]
name: max char16
kernel_name: test_16_max_char
global_size: 12 0 0

arg_out: 0 buffer char[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer char[192] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_max char16
kernel_name: test_tss_16_max_char
global_size: 12 0 0

arg_out: 0 buffer char[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer char[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer char[12] 2 -128 4 1 1 127 -128 127 -128 0 -128 -1

!*/

kernel void test_1_max_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_char(global char* out, global char* in0, global char* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_char(global char* out, global char* in0, global char* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_char(global char* out, global char* in0, global char* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_char(global char* out, global char* in0, global char* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_char(global char* out, global char* in0, global char* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_char(global char* out, global char* in0, global char* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_char(global char* out, global char* in0, global char* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_char(global char* out, global char* in0, global char* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

