/*!
[config]
name: Test char hadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hadd char1
kernel_name: test_1_hadd_char
global_size: 7 0 0

arg_out: 0 buffer char[7] 32 0 10 127 -128 -1 -1  tolerance 0 
arg_in: 1 buffer char[7] 32 1 12 127 -128 127 -128 
arg_in: 2 buffer char[7] 33 0 8 127 -128 -128 127 

[test]
name: hadd char2
kernel_name: test_2_hadd_char
global_size: 7 0 0

arg_out: 0 buffer char[14] 32 32 0 0 10 10 127 127 -128 -128 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[14] 32 32 1 1 12 12 127 127 -128 -128 127 127 -128 -128 
arg_in: 2 buffer char[14] 33 33 0 0 8 8 127 127 -128 -128 -128 -128 127 127 

[test]
name: hadd char4
kernel_name: test_4_hadd_char
global_size: 7 0 0

arg_out: 0 buffer char[28] 32 32 32 32 0 0 0 0 10 10 10 10 127 127 127 127 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[28] 32 32 32 32 1 1 1 1 12 12 12 12 127 127 127 127 -128 -128 -128 -128 127 127 127 127 -128 -128 -128 -128 
arg_in: 2 buffer char[28] 33 33 33 33 0 0 0 0 8 8 8 8 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 

[test]
name: hadd char8
kernel_name: test_8_hadd_char
global_size: 7 0 0

arg_out: 0 buffer char[56] 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[56] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 
arg_in: 2 buffer char[56] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 

[test]
name: hadd char16
kernel_name: test_16_hadd_char
global_size: 7 0 0

arg_out: 0 buffer char[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer char[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 
arg_in: 2 buffer char[112] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 

!*/

kernel void test_1_hadd_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = hadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hadd_char(global char* out, global char* in0, global char* in1){
  vstore2(hadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hadd_char(global char* out, global char* in0, global char* in1){
  vstore4(hadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hadd_char(global char* out, global char* in0, global char* in1){
  vstore8(hadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hadd_char(global char* out, global char* in0, global char* in1){
  vstore16(hadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

