/*!
[config]
name: Test char clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz char1
kernel_name: test_1_clz_char
global_size: 5 0 0

arg_out: 0 buffer char[5] 7 1 8 1 0  tolerance 0 
arg_in: 1 buffer char[5] 1 64 0 127 -128 

[test]
name: clz char2
kernel_name: test_2_clz_char
global_size: 5 0 0

arg_out: 0 buffer char[10] 7 7 1 1 8 8 1 1 0 0  tolerance 0 
arg_in: 1 buffer char[10] 1 1 64 64 0 0 127 127 -128 -128 

[test]
name: clz char4
kernel_name: test_4_clz_char
global_size: 5 0 0

arg_out: 0 buffer char[20] 7 7 7 7 1 1 1 1 8 8 8 8 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer char[20] 1 1 1 1 64 64 64 64 0 0 0 0 127 127 127 127 -128 -128 -128 -128 

[test]
name: clz char8
kernel_name: test_8_clz_char
global_size: 5 0 0

arg_out: 0 buffer char[40] 7 7 7 7 7 7 7 7 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer char[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 

[test]
name: clz char16
kernel_name: test_16_clz_char
global_size: 5 0 0

arg_out: 0 buffer char[80] 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer char[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 

!*/

kernel void test_1_clz_char(global char* out, global char* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_char(global char* out, global char* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_char(global char* out, global char* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_char(global char* out, global char* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_char(global char* out, global char* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

