/*!
[config]
name: Test char add_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: add_sat char1
kernel_name: test_1_add_sat_char
global_size: 7 0 0

arg_out: 0 buffer char[7] 127 127 0 -2 64 -128 -128  tolerance 0 
arg_in: 1 buffer char[7] 127 126 32 -8 127 -128 -118 
arg_in: 2 buffer char[7] 64 50 -32 6 -63 -12 -50 

[test]
name: add_sat char2
kernel_name: test_2_add_sat_char
global_size: 7 0 0

arg_out: 0 buffer char[14] 127 127 127 127 0 0 -2 -2 64 64 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[14] 127 127 126 126 32 32 -8 -8 127 127 -128 -128 -118 -118 
arg_in: 2 buffer char[14] 64 64 50 50 -32 -32 6 6 -63 -63 -12 -12 -50 -50 

[test]
name: add_sat char4
kernel_name: test_4_add_sat_char
global_size: 7 0 0

arg_out: 0 buffer char[28] 127 127 127 127 127 127 127 127 0 0 0 0 -2 -2 -2 -2 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[28] 127 127 127 127 126 126 126 126 32 32 32 32 -8 -8 -8 -8 127 127 127 127 -128 -128 -128 -128 -118 -118 -118 -118 
arg_in: 2 buffer char[28] 64 64 64 64 50 50 50 50 -32 -32 -32 -32 6 6 6 6 -63 -63 -63 -63 -12 -12 -12 -12 -50 -50 -50 -50 

[test]
name: add_sat char8
kernel_name: test_8_add_sat_char
global_size: 7 0 0

arg_out: 0 buffer char[56] 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 -2 -2 -2 -2 -2 -2 -2 -2 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[56] 127 127 127 127 127 127 127 127 126 126 126 126 126 126 126 126 32 32 32 32 32 32 32 32 -8 -8 -8 -8 -8 -8 -8 -8 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -118 -118 -118 -118 -118 -118 -118 -118 
arg_in: 2 buffer char[56] 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 -32 -32 -32 -32 -32 -32 -32 -32 6 6 6 6 6 6 6 6 -63 -63 -63 -63 -63 -63 -63 -63 -12 -12 -12 -12 -12 -12 -12 -12 -50 -50 -50 -50 -50 -50 -50 -50 

[test]
name: add_sat char16
kernel_name: test_16_add_sat_char
global_size: 7 0 0

arg_out: 0 buffer char[112] 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128  tolerance 0 
arg_in: 1 buffer char[112] 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 -118 
arg_in: 2 buffer char[112] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 -32 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -12 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 -50 

!*/

kernel void test_1_add_sat_char(global char* out, global char* in0, global char* in1){
  out[get_global_id(0)] = add_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_add_sat_char(global char* out, global char* in0, global char* in1){
  vstore2(add_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_add_sat_char(global char* out, global char* in0, global char* in1){
  vstore4(add_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_add_sat_char(global char* out, global char* in0, global char* in1){
  vstore8(add_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_add_sat_char(global char* out, global char* in0, global char* in1){
  vstore16(add_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

