/*!
[config]
name: Test char abs_diff built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs_diff char1
kernel_name: test_1_abs_diff_char
global_size: 7 0 0

arg_out: 0 buffer uchar[7] 0 1 1 255 255 1 15  tolerance 0 
arg_in: 1 buffer char[7] 0 1 0 -128 127 0 -8 
arg_in: 2 buffer char[7] 0 0 1 127 -128 1 7 

[test]
name: abs_diff char2
kernel_name: test_2_abs_diff_char
global_size: 7 0 0

arg_out: 0 buffer uchar[14] 0 0 1 1 1 1 255 255 255 255 1 1 15 15  tolerance 0 
arg_in: 1 buffer char[14] 0 0 1 1 0 0 -128 -128 127 127 0 0 -8 -8 
arg_in: 2 buffer char[14] 0 0 0 0 1 1 127 127 -128 -128 1 1 7 7 

[test]
name: abs_diff char4
kernel_name: test_4_abs_diff_char
global_size: 7 0 0

arg_out: 0 buffer uchar[28] 0 0 0 0 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 1 1 1 1 15 15 15 15  tolerance 0 
arg_in: 1 buffer char[28] 0 0 0 0 1 1 1 1 0 0 0 0 -128 -128 -128 -128 127 127 127 127 0 0 0 0 -8 -8 -8 -8 
arg_in: 2 buffer char[28] 0 0 0 0 0 0 0 0 1 1 1 1 127 127 127 127 -128 -128 -128 -128 1 1 1 1 7 7 7 7 

[test]
name: abs_diff char8
kernel_name: test_8_abs_diff_char
global_size: 7 0 0

arg_out: 0 buffer uchar[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer char[56] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer char[56] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 

[test]
name: abs_diff char16
kernel_name: test_16_abs_diff_char
global_size: 7 0 0

arg_out: 0 buffer uchar[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15  tolerance 0 
arg_in: 1 buffer char[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 -8 
arg_in: 2 buffer char[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_abs_diff_char(global uchar* out, global char* in0, global char* in1){
  out[get_global_id(0)] = abs_diff(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_abs_diff_char(global uchar* out, global char* in0, global char* in1){
  vstore2(abs_diff(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_abs_diff_char(global uchar* out, global char* in0, global char* in1){
  vstore4(abs_diff(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_abs_diff_char(global uchar* out, global char* in0, global char* in1){
  vstore8(abs_diff(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_abs_diff_char(global uchar* out, global char* in0, global char* in1){
  vstore16(abs_diff(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

