/*!
[config]
name: Test char abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs char1
kernel_name: test_1_abs_char
global_size: 6 0 0

arg_out: 0 buffer uchar[6] 0 2 128 127 1 13  tolerance 0 
arg_in: 1 buffer char[6] 0 2 -128 127 -1 -13 

[test]
name: abs char2
kernel_name: test_2_abs_char
global_size: 6 0 0

arg_out: 0 buffer uchar[12] 0 0 2 2 128 128 127 127 1 1 13 13  tolerance 0 
arg_in: 1 buffer char[12] 0 0 2 2 -128 -128 127 127 -1 -1 -13 -13 

[test]
name: abs char4
kernel_name: test_4_abs_char
global_size: 6 0 0

arg_out: 0 buffer uchar[24] 0 0 0 0 2 2 2 2 128 128 128 128 127 127 127 127 1 1 1 1 13 13 13 13  tolerance 0 
arg_in: 1 buffer char[24] 0 0 0 0 2 2 2 2 -128 -128 -128 -128 127 127 127 127 -1 -1 -1 -1 -13 -13 -13 -13 

[test]
name: abs char8
kernel_name: test_8_abs_char
global_size: 6 0 0

arg_out: 0 buffer uchar[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 128 128 128 128 128 128 128 128 127 127 127 127 127 127 127 127 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer char[48] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 

[test]
name: abs char16
kernel_name: test_16_abs_char
global_size: 6 0 0

arg_out: 0 buffer uchar[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13  tolerance 0 
arg_in: 1 buffer char[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 -13 

!*/

kernel void test_1_abs_char(global uchar* out, global char* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_char(global uchar* out, global char* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_char(global uchar* out, global char* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_char(global uchar* out, global char* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_char(global uchar* out, global char* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

