/*!
[config]
name: Test float step built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: step float1
kernel_name: test_1_step_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 1.0 1.0 0.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[6] 1.0 -0.5 0.0 0.0 1.0 nan 
arg_in: 2 buffer float[6] 0.0 0.0 0.0 -0.5 nan 1.0 

[test]
name: step float2
kernel_name: test_2_step_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[12] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 1.0 1.0 nan nan 
arg_in: 2 buffer float[12] 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 nan nan 1.0 1.0 

[test]
name: step float4
kernel_name: test_4_step_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[24] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 nan nan nan nan 
arg_in: 2 buffer float[24] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 nan nan nan nan 1.0 1.0 1.0 1.0 

[test]
name: step float8
kernel_name: test_8_step_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 

[test]
name: step float16
kernel_name: test_16_step_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 

!*/

kernel void test_1_step_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = step(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_step_float(global float* out, global float* in0, global float* in1){
  vstore2(step(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_step_float(global float* out, global float* in0, global float* in1){
  vstore4(step(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_step_float(global float* out, global float* in0, global float* in1){
  vstore8(step(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_step_float(global float* out, global float* in0, global float* in1){
  vstore16(step(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

