/*!
[config]
name: Test float sign built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sign float1
kernel_name: test_1_sign_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 1.0 -1.0 0.0 -0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[5] 0.5 -0.5 0.0 -0.0 nan 

[test]
name: sign float2
kernel_name: test_2_sign_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 1.0 1.0 -1.0 -1.0 0.0 0.0 -0.0 -0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[10] 0.5 0.5 -0.5 -0.5 0.0 0.0 -0.0 -0.0 nan nan 

[test]
name: sign float4
kernel_name: test_4_sign_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[20] 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan 

[test]
name: sign float8
kernel_name: test_8_sign_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[40] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan 

[test]
name: sign float16
kernel_name: test_16_sign_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_sign_float(global float* out, global float* in0){
  out[get_global_id(0)] = sign(in0[get_global_id(0)]);
}

kernel void test_2_sign_float(global float* out, global float* in0){
  vstore2(sign(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_sign_float(global float* out, global float* in0){
  vstore4(sign(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_sign_float(global float* out, global float* in0){
  vstore8(sign(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_sign_float(global float* out, global float* in0){
  vstore16(sign(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

