/*!
[config]
name: Test float mix built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mix float1
kernel_name: test_1_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[10] 0.5 -0.25 0.0 -0.5 1.0 3.0 10.0 nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[10] 1.0 -0.5 0.0 0.0 1.0 4.0 15.0 5.0 4.0 nan 
arg_in: 2 buffer float[10] 0.0 0.0 0.0 -0.5 2.0 2.0 10.0 -0.2 nan 1.5 
arg_in: 3 buffer float[10] 0.5 0.5 0.0 1.0 0.0 0.5 1.0 nan 1.0 0.0 

[test]
name: mix float2
kernel_name: test_2_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[20] 0.5 0.5 -0.25 -0.25 0.0 0.0 -0.5 -0.5 1.0 1.0 3.0 3.0 10.0 10.0 nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[20] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 1.0 1.0 4.0 4.0 15.0 15.0 5.0 5.0 4.0 4.0 nan nan 
arg_in: 2 buffer float[20] 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 2.0 2.0 2.0 2.0 10.0 10.0 -0.2 -0.2 nan nan 1.5 1.5 
arg_in: 3 buffer float[20] 0.5 0.5 0.5 0.5 0.0 0.0 1.0 1.0 0.0 0.0 0.5 0.5 1.0 1.0 nan nan 1.0 1.0 0.0 0.0 

[test]
name: tts_mix float2
kernel_name: test_tts_2_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[20] 0.5 0.5 -0.25 -0.25 0.0 0.0 -0.5 -0.5 1.0 1.0 3.0 3.0 10.0 10.0 nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[20] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 1.0 1.0 4.0 4.0 15.0 15.0 5.0 5.0 4.0 4.0 nan nan 
arg_in: 2 buffer float[20] 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 2.0 2.0 2.0 2.0 10.0 10.0 -0.2 -0.2 nan nan 1.5 1.5 
arg_in: 3 buffer float[10] 0.5 0.5 0.0 1.0 0.0 0.5 1.0 nan 1.0 0.0

[test]
name: mix float4
kernel_name: test_4_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[40] 0.5 0.5 0.5 0.5 -0.25 -0.25 -0.25 -0.25 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 3.0 3.0 3.0 3.0 10.0 10.0 10.0 10.0 nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[40] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 15.0 15.0 15.0 15.0 5.0 5.0 5.0 5.0 4.0 4.0 4.0 4.0 nan nan nan nan 
arg_in: 2 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 10.0 10.0 10.0 10.0 -0.2 -0.2 -0.2 -0.2 nan nan nan nan 1.5 1.5 1.5 1.5 
arg_in: 3 buffer float[40] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 1.0 1.0 1.0 1.0 nan nan nan nan 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 

[test]
name: tts_mix float4
kernel_name: test_tts_4_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[40] 0.5 0.5 0.5 0.5 -0.25 -0.25 -0.25 -0.25 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 3.0 3.0 3.0 3.0 10.0 10.0 10.0 10.0 nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[40] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 15.0 15.0 15.0 15.0 5.0 5.0 5.0 5.0 4.0 4.0 4.0 4.0 nan nan nan nan 
arg_in: 2 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 10.0 10.0 10.0 10.0 -0.2 -0.2 -0.2 -0.2 nan nan nan nan 1.5 1.5 1.5 1.5 
arg_in: 3 buffer float[10] 0.5 0.5 0.0 1.0 0.0 0.5 1.0 nan 1.0 0.0

[test]
name: mix float8
kernel_name: test_8_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[80] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 nan nan nan nan nan nan nan nan 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 
arg_in: 3 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: tts_mix float8
kernel_name: test_tts_8_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[80] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 nan nan nan nan nan nan nan nan 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 
arg_in: 3 buffer float[10] 0.5 0.5 0.0 1.0 0.0 0.5 1.0 nan 1.0 0.0

[test]
name: mix float16
kernel_name: test_16_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[160] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[160] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[160] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 
arg_in: 3 buffer float[160] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 

[test]
name: tts_mix float16
kernel_name: test_tts_16_mix_float
global_size: 10 0 0

arg_out: 0 buffer float[160] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 -0.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 3.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[160] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 15.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 5.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[160] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 2.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 10.0 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 -0.2 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 
arg_in: 3 buffer float[10] 0.5 0.5 0.0 1.0 0.0 0.5 1.0 nan 1.0 0.0

!*/

kernel void test_1_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  out[get_global_id(0)] = mix(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore2(mix(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore4(mix(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore8(mix(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore16(mix(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tts_2_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore2(mix(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tts_4_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore4(mix(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tts_8_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore8(mix(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tts_16_mix_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore16(mix(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), in2[get_global_id(0)]), get_global_id(0), out);
}

