/*!
[config]
name: Test float min built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: min float1
kernel_name: test_1_min_float
global_size: 4 0 0

arg_out: 0 buffer float[4] 0.0 -0.5 0.0 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[4] 1.0 -0.5 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5 

[test]
name: min float2
kernel_name: test_2_min_float
global_size: 4 0 0

arg_out: 0 buffer float[8] 0.0 0.0 -0.5 -0.5 0.0 0.0 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[8] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[8] 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 

[test]
name: tss_min float2
kernel_name: test_tss_2_min_float
global_size: 4 0 0

arg_out: 0 buffer float[8] 0.0 0.0 -0.5 -0.5 0.0 0.0 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[8] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

[test]
name: min float4
kernel_name: test_4_min_float
global_size: 4 0 0

arg_out: 0 buffer float[16] 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[16] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[16] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 

[test]
name: tss_min float4
kernel_name: test_tss_4_min_float
global_size: 4 0 0

arg_out: 0 buffer float[16] 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[16] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

[test]
name: min float8
kernel_name: test_8_min_float
global_size: 4 0 0

arg_out: 0 buffer float[32] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[32] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 

[test]
name: tss_min float8
kernel_name: test_tss_8_min_float
global_size: 4 0 0

arg_out: 0 buffer float[32] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

[test]
name: min float16
kernel_name: test_16_min_float
global_size: 4 0 0

arg_out: 0 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 

[test]
name: tss_min float16
kernel_name: test_tss_16_min_float
global_size: 4 0 0

arg_out: 0 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5  tolerance 0 ulp
arg_in: 1 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

!*/

kernel void test_1_min_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = min(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_min_float(global float* out, global float* in0, global float* in1){
  vstore2(min(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_min_float(global float* out, global float* in0, global float* in1){
  vstore4(min(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_min_float(global float* out, global float* in0, global float* in1){
  vstore8(min(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_min_float(global float* out, global float* in0, global float* in1){
  vstore16(min(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_min_float(global float* out, global float* in0, global float* in1){
  vstore2(min(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_min_float(global float* out, global float* in0, global float* in1){
  vstore4(min(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_min_float(global float* out, global float* in0, global float* in1){
  vstore8(min(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_min_float(global float* out, global float* in0, global float* in1){
  vstore16(min(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

