/*!
[config]
name: Test float max built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: max float1
kernel_name: test_1_max_float
global_size: 4 0 0

arg_out: 0 buffer float[4] 1.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[4] 1.0 -0.5 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5 

[test]
name: max float2
kernel_name: test_2_max_float
global_size: 4 0 0

arg_out: 0 buffer float[8] 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[8] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[8] 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 

[test]
name: tss_max float2
kernel_name: test_tss_2_max_float
global_size: 4 0 0

arg_out: 0 buffer float[8] 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[8] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

[test]
name: max float4
kernel_name: test_4_max_float
global_size: 4 0 0

arg_out: 0 buffer float[16] 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[16] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[16] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 

[test]
name: tss_max float4
kernel_name: test_tss_4_max_float
global_size: 4 0 0

arg_out: 0 buffer float[16] 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[16] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

[test]
name: max float8
kernel_name: test_8_max_float
global_size: 4 0 0

arg_out: 0 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[32] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 

[test]
name: tss_max float8
kernel_name: test_tss_8_max_float
global_size: 4 0 0

arg_out: 0 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[32] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

[test]
name: max float16
kernel_name: test_16_max_float
global_size: 4 0 0

arg_out: 0 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 

[test]
name: tss_max float16
kernel_name: test_tss_16_max_float
global_size: 4 0 0

arg_out: 0 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0  tolerance 0 ulp
arg_in: 1 buffer float[64] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 
arg_in: 2 buffer float[4] 0.0 0.0 0.0 -0.5

!*/

kernel void test_1_max_float(global float* out, global float* in0, global float* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_float(global float* out, global float* in0, global float* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_float(global float* out, global float* in0, global float* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_float(global float* out, global float* in0, global float* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_float(global float* out, global float* in0, global float* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_float(global float* out, global float* in0, global float* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_float(global float* out, global float* in0, global float* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_float(global float* out, global float* in0, global float* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_float(global float* out, global float* in0, global float* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

