/*!
[config]
name: Test float degrees built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: degrees float1
kernel_name: test_1_degrees_float
global_size: 8 0 0

arg_out: 0 buffer float[8] 28.64788975654116 -28.64788975654116 180.0 0.0 360 1800.0 18000 90  tolerance 0 ulp
arg_in: 1 buffer float[8] 0.5 -0.5 3.141592653589793 0.0 6.283185307179586 31.41592653589793 314.1592653589793 1.5707963267948966 

[test]
name: degrees float2
kernel_name: test_2_degrees_float
global_size: 8 0 0

arg_out: 0 buffer float[16] 28.64788975654116 28.64788975654116 -28.64788975654116 -28.64788975654116 180.0 180.0 0.0 0.0 360 360 1800.0 1800.0 18000 18000 90 90  tolerance 0 ulp
arg_in: 1 buffer float[16] 0.5 0.5 -0.5 -0.5 3.141592653589793 3.141592653589793 0.0 0.0 6.283185307179586 6.283185307179586 31.41592653589793 31.41592653589793 314.1592653589793 314.1592653589793 1.5707963267948966 1.5707963267948966 

[test]
name: degrees float4
kernel_name: test_4_degrees_float
global_size: 8 0 0

arg_out: 0 buffer float[32] 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 180.0 180.0 180.0 180.0 0.0 0.0 0.0 0.0 360 360 360 360 1800.0 1800.0 1800.0 1800.0 18000 18000 18000 18000 90 90 90 90  tolerance 0 ulp
arg_in: 1 buffer float[32] 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 

[test]
name: degrees float8
kernel_name: test_8_degrees_float
global_size: 8 0 0

arg_out: 0 buffer float[64] 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 360 360 360 360 360 360 360 360 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 18000 18000 18000 18000 18000 18000 18000 18000 90 90 90 90 90 90 90 90  tolerance 0 ulp
arg_in: 1 buffer float[64] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 

[test]
name: degrees float16
kernel_name: test_16_degrees_float
global_size: 8 0 0

arg_out: 0 buffer float[128] 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 -28.64788975654116 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 180.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 360 360 360 360 360 360 360 360 360 360 360 360 360 360 360 360 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 1800.0 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 18000 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90  tolerance 0 ulp
arg_in: 1 buffer float[128] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 6.283185307179586 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 31.41592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 314.1592653589793 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 

!*/

kernel void test_1_degrees_float(global float* out, global float* in0){
  out[get_global_id(0)] = degrees(in0[get_global_id(0)]);
}

kernel void test_2_degrees_float(global float* out, global float* in0){
  vstore2(degrees(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_degrees_float(global float* out, global float* in0){
  vstore4(degrees(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_degrees_float(global float* out, global float* in0){
  vstore8(degrees(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_degrees_float(global float* out, global float* in0){
  vstore16(degrees(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

