/*!
[config]
name: Test float clamp built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clamp float1
kernel_name: test_1_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 0.5 0.0 0.0 0.0 nan  tolerance 0 ulp
arg_in: 1 buffer float[5] 1.0 -0.5 0.0 0.0 nan 
arg_in: 2 buffer float[5] 0.0 0.0 0.0 -0.5 nan 
arg_in: 3 buffer float[5] 0.5 0.5 0.0 0.5 nan 

[test]
name: clamp float2
kernel_name: test_2_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 nan nan  tolerance 0 ulp
arg_in: 1 buffer float[10] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 nan nan 
arg_in: 2 buffer float[10] 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 nan nan 
arg_in: 3 buffer float[10] 0.5 0.5 0.5 0.5 0.0 0.0 0.5 0.5 nan nan 

[test]
name: tss_clamp float2
kernel_name: test_tss_2_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 nan nan  tolerance 0 ulp
arg_in: 1 buffer float[10] 1.0 1.0 -0.5 -0.5 0.0 0.0 0.0 0.0 nan nan 
arg_in: 2 buffer float[5] 0.0 0.0 0.0 -0.5 nan
arg_in: 3 buffer float[5] 0.5 0.5 0.0 0.5 nan

[test]
name: clamp float4
kernel_name: test_4_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[20] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan 
arg_in: 2 buffer float[20] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 nan nan nan nan 
arg_in: 3 buffer float[20] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 nan nan nan nan 

[test]
name: tss_clamp float4
kernel_name: test_tss_4_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[20] 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan 
arg_in: 2 buffer float[5] 0.0 0.0 0.0 -0.5 nan
arg_in: 3 buffer float[5] 0.5 0.5 0.0 0.5 nan

[test]
name: clamp float8
kernel_name: test_8_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[40] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[40] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan 
arg_in: 3 buffer float[40] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan 

[test]
name: tss_clamp float8
kernel_name: test_tss_8_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[40] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[5] 0.0 0.0 0.0 -0.5 nan
arg_in: 3 buffer float[5] 0.5 0.5 0.0 0.5 nan

[test]
name: clamp float16
kernel_name: test_16_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[80] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[80] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 3 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

[test]
name: tss_clamp float16
kernel_name: test_tss_16_clamp_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 0 ulp
arg_in: 1 buffer float[80] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 
arg_in: 2 buffer float[5] 0.0 0.0 0.0 -0.5 nan
arg_in: 3 buffer float[5] 0.5 0.5 0.0 0.5 nan

!*/

kernel void test_1_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  out[get_global_id(0)] = clamp(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_clamp_float(global float* out, global float* in0, global float* in1, global float* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

