#!/bin/bash

#PER DPLL registers
PER_PLL_REGS=(
  'PER_PLL_M  0x4A00814C 18-8'
  'PER_PLL_N  0x4A00814C 6-0'
  'PER_PLL_M2 0x4A008150 4-0'
  'PER_PLL_M3 0x4A008154 4-0'
  'PER_PLL_H11 0x4A008158 5-0'
  'PER_PLL_H12 0x4A00815C 5-0'
  'PER_PLL_H14 0x4A008164 5-0'
)

#Core DPLL registers
CORE_PLL_REGS=(
  'CORE_PLL_M 0x4A00412C 18-8'
  'CORE_PLL_N 0x4A00412C 6-0'
  'CORE_PLL_M2 0x4A004130 4-0'
  'CORE_PLL_M3 0x4A004134 4-0'
  'CORE_PLL_H11 0x4A004138 5-0'
  'CORE_PLL_H12 0x4A00413C 5-0'
  'CORE_PLL_H13 0x4A004140 5-0'
  'CORE_PLL_H14 0x4A004144 5-0'
  'CORE_PLL_H22 0x4A004154 5-0'
  'CORE_PLL_H23 0x4A004158 5-0'
  'CORE_PLL_H24 0x4A00415C 5-0'
)

#ABE DPLL registers
ABE_PLL_REGS=(
  'ABE_PLL_M 0x4A0041EC 18-8'
  'ABE_PLL_N 0x4A0041EC 6-0'
  'ABE_PLL_M2 0x4A0041F0 4-0'
  'ABE_PLL_M3 0x4A0041F4 4-0'
  'ABE_PLL_REGM4 0x4A0041E0 11'
)

#MPU DPLL registers
MPU_PLL_REGS=(
  'MPU_PLL_M 0x4A00416C 18-8'
  'MPU_PLL_N 0x4A00416C 6-0'
  'MPU_PLL_M2 0x4A004170 4-0'
)

#IVA DPLL registers
IVA_PLL_REGS=(
  'IVA_PLL_M  0x4A0041AC 18-8'
  'IVA_PLL_N  0x4A0041AC 6-0'
  'IVA_PLL_H11 0x4A0041B8 5-0'
  'IVA_PLL_H12 0x4A0041BC 5-0'
)

#USB DPLL registers
USB_PLL_REGS=(
  'USB_PLL_M 0x4A00818C 19-8'
  'USB_PLL_N 0x4A00818C 7-0'
  'USB_PLL_M2 0x4A008190 6-0'
)

#PRM registers
PRM_REGS=(
  'PRM_ABE_DPLL_CLK_MUX 0x4AE0610C 0'
  'PRM_WKUPAON_ICLK_MUX 0x4AE06108 0'
  'PRM_ABE_DPLL_BYPASS_CLK_MUX 0x4AE06108 0'
  'PRM_ABE_SYS_CLK_DIV 0x4AE06100 0'
  'PRM_MPU_DPLL_CLK_ABE_DIV  0x4A004320 26'
  'PRM_MPU_DPLL_CLK_EMIF_DIV 0x4A004320 25-24'
  'PRM_L3INSTR_TS_GCLK_AND_DLL_AGING_CLK_DIV 0x4A008E50 25-24'
)

#CM_CORE_AON part a registers
CM_CORE_AON_REGS=(
  'CM_CORE_AON_L3_ICLK_DIV 0x4A004100 4'
  'CM_CORE_AON_L4_ROOT_CLK_DIV 0x4A004100 8'
  'CM_CORE_AON_MPU_DPLL_HS_CLK_DIV 0x4A00419C 1-0' 
  'CM_CORE_AON_IVA_DPLL_HS_CLK_DIV 0x4A0041DC 1-0'
)

#CKGEN_USB registers
CKGEN_USB_REGS=(
  'CKGEN_USB_L3_INIT_60M_FCLK_DIV 0x4A008104 0'
  'CKGEN_USB_UTMI_P1_GFCLK_MUX 0x4A009658 24'
  'CKGEN_USB_UTMI_P2_GFCLK_MUX 0x4A009658 25'
)

#CKGEN_ABE registers
CKGEN_ABE_REGS=(
  'CKGEN_ABE_CLK_DIV 0x4A004108 1-0'
  'CKGEN_AESS_FCLK_ABE_GICLK_DIV 0x4A004528 24'
  'CKGEN_ABE_TIMER5_GFCLK_MUX 0x4A004568 24'
  'CKGEN_ABE_TIMER6_GFCLK_MUX 0x4A004570 24'
  'CKGEN_ABE_TIMER7_GFCLK_MUX 0x4A004578 24'
  'CKGEN_ABE_TIMER8_GFCLK_MUX 0x4A004580 24'
  'CKGEN_ABE_DMIC_GFCLK_MUX 0x4A004538 25-24'
  'CKGEN_ABE_DMIC_INT_MUX 0x4A004538 27-26'
  'CKGEN_ABE_MCASP_INT_MUX 0x4A004540 27-26'
  'CKGEN_ABE_MCASP_GFCLK_MUX 0x4A004540 25-24'
  'CKGEN_ABE_MCBSP1_GFCLK_MUX 0x4A004548 25-24'
  'CKGEN_ABE_MCBSP1_INT_MUX 0x4A004548 27-26'
  'CKGEN_ABE_MCBSP2_GFCLK_MUX 0x4A004550 25-24'
  'CKGEN_ABE_MCBSP2_INT_MUX 0x4A004550 27-26'
  'CKGEN_ABE_MCBSP3_GFCLK_MUX 0x4A004558 25-24'
  'CKGEN_ABE_MCBSP3_INT_MUX 0x4A004558 27-26'
)

#CM_CORE registers
CM_CORE_REGS=(
  'CM_CORE_MMC1_GFCLK_MUX 0x4A009628 24'
  'CM_CORE_MMC1_GFCLK_DIV 0x4A009628 25'
  'CM_CORE_MMC2_GFCLK_MUX 0x4A009630 24'
  'CM_CORE_MMC2_GFCLK_DIV 0x4A009630 25'
  'CM_CORE_GPU_HYD_GCLK_MUX 0x4A009520 25'
  'CM_CORE_GPU_CORE_GCLK_MUX 0x4A009520 24'
  'CM_CORE_FDIF_GFCLK_DIV 0x4A009328 24'
  'CM_CORE_HSI_GFCLK_DIV 0x4A009638 24'
  'CM_CORE_GPU_L3_DIV 0x4A009520 26'
)

#TIMERs registers
TIMERS_REGS=(
  'TIMER1_GFCLK_MUX 0x4AE07940 24'
  'TIMER2_GFCLK_MUX 0x4A009038 24'
  'TIMER3_GFCLK_MUX 0x4A009040 24'
  'TIMER4_GFCLK_MUX 0x4A009048 24'
  'TIMER9_GFCLK_MUX 0x4A009050 24'
  'TIMER10_GFCLK_MUX 0x4A009028 24'
  'TIMER11_GFCLK_MUX 0x4A009030 24'
)


source clk_framework_utils.sh

set_tree_input PER_PLL_REGS[@]
set_tree_input CORE_PLL_REGS[@]
set_tree_input ABE_PLL_REGS[@]
set_tree_input MPU_PLL_REGS[@]
set_tree_input IVA_PLL_REGS[@]
set_tree_input USB_PLL_REGS[@]
set_tree_input PRM_REGS[@]
set_tree_input CM_CORE_AON_REGS[@]
set_tree_input CKGEN_USB_REGS[@]
set_tree_input CKGEN_ABE_REGS[@]
set_tree_input CM_CORE_REGS[@]
set_tree_input TIMERS_REGS[@]

source omap5_clk_framework_tree.sh

