#!/bin/bash

#OPP_NOM Setting for DRA7xx


#PER DPLL settings
PER_PLL_M=96
PER_PLL_N=4
PER_PLL_M2=4
PER_PLL_H11=2
PER_PLL_H12=3
PER_PLL_H13=9
PER_PLL_H14=1

#Core DPLL Settings
CORE_PLL_M=266
CORE_PLL_N=4
CORE_PLL_M2=2
CORE_PLL_H12=3
CORE_PLL_H13=61
CORE_PLL_H14=4
CORE_PLL_H22=4
CORE_PLL_H23=3
CORE_PLL_H24=5

#ABE DPLL Settings
#Info missing from the TRM
ABE_PLL_M=8
ABE_PLL_N=0
ABE_PLL_M2=1
ABE_PLL_REGM4XEN=0
ABE_PLL_M3=1

#MPU DPLL Settings
#Nominal Settings
MPU_PLL_M=50
MPU_PLL_N=0
MPU_PLL_M2=1

#IVA DPLL Settings
#Nominal Settings 
IVA_PLL_M=233
IVA_PLL_N=3
IVA_PLL_M2=3

#USB DPLL Settings
USB_PLL_M=48
USB_PLL_N=0
USB_PLL_M2=2

#EVE DPLL Settings
#Nominal Settings
EVE_PLL_M=107
EVE_PLL_N=1
EVE_PLL_M2=2

#DSP DPLL Settings
#Nominal Settings
DSP_PLL_M=30
DSP_PLL_N=0
DSP_PLL_M2=1
DSP_PLL_M3=3

#GMAC DPLL Settings
GMAC_PLL_M=5
GMAC_PLL_N=0
GMAC_PLL_M2=4
GMAC_PLL_M3=10
GMAC_PLL_H11=39
GMAC_PLL_H12=7
GMAC_PLL_H13=9

#GPU DPLL Settings
#Nominal Settings
GPU_PLL_M=85
GPU_PLL_N=1
GPU_PLL_M2=2

#DDR DPLL Settings
#Nominal Settings
DDR_PLL_M=266
DDR_PLL_N=4
DDR_PLL_M2=2
DDR_PLL_H11=7

#PCIE Ref PLL Settings
PCIE_REF_PLL_M=75
PCIE_REF_PLL_N=0
PCIE_REF_PLL_M2=15

#PCIE APLL Settings
PCIE_APLL_M2=1 #Set to 1 until TRM is finalized
PCIE_APLL_DIV=0 #Either 0 (div 1) or 1 (div 2), Set to 0 until TRM is finalized


#USB OTG SS DPLL Settings
USB_OTG_SS_PLL_M=125
USB_OTG_SS_PLL_N=0

#SATA DPLL Settings
SATA_PLL_M=75
SATA_PLL_N=0

#DEBUGSS DPLL Settings
DEBUGSS_PLL_M=95
DEBUGSS_PLL_N=1
DEBUGSS_PLL_M6_HSDIV=2

#Waiting on finalized TRM to continue and review previous settings
#PRM Settings
PRM_ABE_PLL_CLK_MUX=0
PRM_WKUPAON_ICLK_MUX=0
PRM_ABE_DPLL_BYPASS_CLK_MUX=0
PRM_DCAN1_SYS_CLK_MUX=0
PRM_ABE_DPLL_SYS_CLK_MUX=1
PRM_VIDEO1_DPLL_CLK_MUX=0
PRM_VIDEO2_DPLL_CLK_MUX=0
PRM_HDMI_DPLL_CLK_MUX=0
PRM_ABE_SYS_CLK_DIV=0
PRM_TIMER_SYS_CLK_DIV=0
PRM_MPU_DPLL_CLK_ABE_DIV=0
PRM_MPU_DPLL_CLK_EMIF_DIV=1 # 0 or 1 (div 4); 2 or 3 (div 8)
PRM_L3INSTR_TS_GCLK_AND_DLL_AGING_CLK_DIV=0 # 0 (div 8); 1 (div 16); 2 (div 32)

#CM_CORE_AON part a Settings
CM_CORE_AON_L3_ICLK_DIV=1 # 0 or 1 maps to 2^n
CM_CORE_AON_L4_ROOT_CLK_DIV=1 # 0 or 1 maps to 2^n
CM_CORE_AON_MPU_DPLL_HS_CLK_DIV=0 #0, 1, 2, or 3 map to 2^n
CM_CORE_AON_IVA_DPLL_HS_CLK_DIV=0 #0, 1, 2, or 3 map to 2^n
CM_CORE_AON_EVE_DPLL_HS_CLK_DIV=0 #0, 1, 2, or 3 map to 2^n
CM_CORE_AON_DSP_DPLL_HS_CLK_DIV=0 #0, 1, 2, or 3 map to 2^n
CM_CORE_AON_ABE_LP_CLK_DIV=0 #TRM table 3-39 refers to bits 1:0,only bit 0 is used according to register
CM_CORE_AON_ABE_24M_FCLK_DIV=1 #TRM table 3-39 refers to bits 1:0,only bit 0 is used according to register

#CM_CORE_AON part b Settings
CM_CORE_AON_MMC1_GFCLK_MUX=1
CM_CORE_AON_MMC1_GFCLK_DIV=1 # 0, 1, or 2 maps to 2^n
CM_CORE_AON_MMC2_GFCLK_MUX=1
CM_CORE_AON_MMC2_GFCLK_DIV=1 # 0, 1, or 2 maps to 2^n
CM_CORE_AON_MMC3_FCLK_MUX=0
CM_CORE_AON_MMC3_FCLK_DIV=0 # 0, 1, or 2 maps to 2^n
CM_CORE_AON_MMC4_FCLK_MUX=0
CM_CORE_AON_MMC4_FCLK_DIV=0 # 0, 1, or 2 maps to 2^n
CM_CORE_AON_GPU_HYD_GCLK_MUX=0
CM_CORE_AON_GPU_CORE_GCLK_MUX=0
CM_CORE_AON_QSPI_GFCLK_MUX=1
CM_CORE_AON_QSPI_GFCLK_DIV=0 # 0, 1, or 2 maps to 2^n
CM_CORE_AON_VIP1_GCLK_MUX=0
CM_CORE_AON_VIP2_GCLK_MUX=0
CM_CORE_AON_VIP3_GCLK_MUX=0
CM_CORE_AON_ABE_CLK_DIV=0 # 0, 1, 2, 3, or 4 maps to 2^n
CM_CORE_AON_AESS_FCLK_DIV=0 # 0 or 1 maps to 2^n
CM_CORE_AON_ABE_GICLK_DIV=0 # 0 or 1 maps to 2^n
CM_CORE_AON_IPU1_GFCLK_MUX=0
CM_CORE_AON_RGMII_50M_CLK_MUX=0
CM_CORE_AON_ATL_GFCLK_MUX=0
CM_CORE_AON_ATL_SOURCE1_MUX=0
CM_CORE_AON_GMAC_RFT_CLK_MUX=4 #TRM CM_GMAC_GMAC_CLKTCTRL register info does not show sources
CM_CORE_AON_EVE_CLK_MUX=0
CM_CORE_AON_EVE_DCLK_DIV=0 # 0, 1, 2, 3, 4, or 5 maps to 2^n 

#VIDEO1 PLL Settings
VIDEO1_PLL_M=117
VIDEO1_PLL_N=4
#No + 1 for these
VIDEO1_M4_HSDIV=38
VIDEO1_M5_HSDIV=38 #TRM is missing this register info
VIDEO1_M6_HSDIV=38

#VIDEO2 PLL Settings
VIDEO2_PLL_M=297
VIDEO2_PLL_N=7
#No + 1 for these
VIDEO2_M4_HSDIV=10
VIDEO2_M5_HSDIV=10 #TRM is missing this register info
VIDEO2_M6_HSDIV=10

#HDMI PLL Settings
HDMI_PLL_M=464
HDMI_PLL_N=4
HDMI_PLL_M2=1

#CM_CORE_AON_CLKOUTMUX Mux Settings
#All dividers here follow # 0, 1, 2, 3, 4, or 5 maps to 2^n
CLKOUTMUX0_CLK_MUX=0
CLKOUTMUX1_CLK_MUX=0
CLKOUTMUX2_CLK_MUX=0
CLKOUTMUX_SYS_CLK1_DCLK_DIV=0
CLKOUTMUX_SYS_CLK2_DCLK_DIV=0
CLKOUTMUX_PER_ABE_X1_DCLK_DIV=0
CLKOUTMUX_MPU_DCLK_DIV=0
CLKOUTMUX_DSP_DCLK_DIV=0
CLKOUTMUX_IVA_DCLK_DIV=0
CLKOUTMUX_GPU_DCLK_DIV=0
CLKOUTMUX_CORE_DPLL_OUT_DCLK_DIV=0
CLKOUTMUX_EMIF_PHY_DCLK_DIV=0
CLKOUTMUX_GMAC_250M_DCLK_DIV=0
CLKOUTMUX_VIDEO2_DCLK_DIV=0
CLKOUTMUX_VIDEO1_DCLK_DIV=0
CLKOUTMUX_HDMI_DCLK_DIV=0
CLKOUTMUX_FUNC_96M_AON_DCLK_DIV=0
CLKOUTMUX_L3INIT_480M_DCLK_DIV=0
CLKOUTMUX_USB_OTG_DCLK_DIV=0
CLKOUTMUX_SATA_DCLK_DIV=0
CLKOUTMUX_PCIE2_DCLK_DIV=0
CLKOUTMUX_PCIE1_DCLK_DIV=0
CLKOUTMUX_EMU_DCLK_DIV=0

#TIMERs Settings
TIMER_VIDEO1_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n; 5 div 22; 6 div 32
TIMER_VIDEO2_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n; 5 div 22; 6 div 32
TIMER_HDMI_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n; 5 div 22; 6 div 32
TIMER1_GFCLK_MUX=1
TIMER2_GFCLK_MUX=0
TIMER3_GFCLK_MUX=0
TIMER4_GFCLK_MUX=0
TIMER5_GFCLK_MUX=0
TIMER6_GFCLK_MUX=0
TIMER7_GFCLK_MUX=0
TIMER8_GFCLK_MUX=0
TIMER9_GFCLK_MUX=0
TIMER10_GFCLK_MUX=0
TIMER11_GFCLK_MUX=0
TIMER13_GFCLK_MUX=0
TIMER14_GFCLK_MUX=0
TIMER15_GFCLK_MUX=0
TIMER16_GFCLK_MUX=0

#CM_CORE_AON MCASPs Settings
#MCASP AUX_GFCLK Settings
MCASP1_AUX_GFCLK_MUX=0
MCASP2_AUX_GFCLK_MUX=0
MCASP3_AUX_GFCLK_MUX=0
MCASP4_AUX_GFCLK_MUX=0
MCASP5_AUX_GFCLK_MUX=0
MCASP6_AUX_GFCLK_MUX=0
MCASP7_AUX_GFCLK_MUX=0
MCASP8_AUX_GFCLK_MUX=0
MCASP_VIDEO1_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n
MCASP_VIDEO2_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n
MCASP_HDMI_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n
MCASP_PER_ABE_X1_GFCLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n
#MCASP AHCLKX and AHCLKR Settings
MCASP1_AHCLKX_MUX=0
MCASP1_AHCLKR_MUX=0
MCASP2_AHCLKX_MUX=0
MCASP2_AHCLKR_MUX=0
MCASP_MLB_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n
MCASP_MLBP_CLK_DIV=0 # 0, 1, 2, 3 and 4 map to 2^n
MCASP3_AHCLKX_MUX=0
MCASP4_AHCLKX_MUX=0
MCASP5_AHCLKX_MUX=0
MCASP6_AHCLKX_MUX=0
MCASP7_AHCLKX_MUX=0
MCASP8_AHCLKX_MUX=0

source dra7xx_clk_framework_tree.sh

