
#Core PLL registers
CORE_PLL_REGS=( 
  'CORE_PLL_M 0x44E00468 18-8'
  'CORE_PLL_N 0x44E00468 6-0'
  'CORE_PLL_REGXM4 0x44E00490 11'
  'CORE_HSDIV_M4 0x44E00480 4-0'
  'CORE_HSDIV_M5 0x44E00484 4-0'
  'CORE_HSDIV_M6 0x44E00484 4-0'
  'CORE_PLL_PRCM_MUXA 0x44E004D8 4-0'
  'CORE_PLL_PRCM_DIVB 0x44E0052C 1'
  'CORE_PLL_PRCM_MUXC 0x44E00530 0'
  'CORE_PLL_PRCM_MUXD 0x44E00520 0'
)
#CORE_PLL_MHZ_50_DIV_REG='0x44E00 '

#Peripheral PLL registers
PER_PLL_REGS=(
  'PER_PLL_M 0x44E0042C 19-8'
  'PER_PLL_N 0x44E0042C 7-0'
  'PER_PLL_M2 0x44E004AC 6-0'
)
#PER_PLL_DIV_MUX_REG='0x44E00 '

#MPU PLL registers
MPU_PLL_REGS=(
  'MPU_PLL_M 0x44E0042C 18-8'
  'MPU_PLL_N 0x44E0042C 6-0'
  'MPU_PLL_M2 0x44E004A8 4-0'
  'MPU_PLL_REGXM4 0x44E00488 11'
)

#DDR PLL registers
DDR_PLL_REGS=(
  'DDR_PLL_M 0x44E00440 18-8'
  'DDR_PLL_N 0x44E00440 6-0'
  'DDR_PLL_M2 0x44E004A0 4-0'
  'DDR_PLL_REGXM4 0x44E00494 11'
)

#Display PLL registers
DISP_PLL_REGS=(
  'DISP_PLL_M 0x44E00454 18-8'
  'DISP_PLL_N 0x44E00454 6-0'
  'DISP_PLL_M2 0x44E004A4 4-0'
  'DISP_PLL_REGXM4 0x44E00498 11'
  'DISP_PLL_PRCM_MUX 0x44E00534 1-0'
)

#Timers registers and clock
TIMERS_REGS=(
  'TIMER1_MUX 0x44E00528 2-0'
  'TIMER2_MUX 0x44E00508 1-0'
  'TIMER3_MUX 0x44E0050C 1-0'
  'TIMER4_MUX 0x44E00510 1-0'
  'TIMER5_MUX 0x44E00518 1-0'
  'TIMER6_MUX 0x44E0051C 1-0'
  'TIMER7_MUX 0x44E00504 1-0'
)

source clk_framework_utils.sh

set_tree_input CORE_PLL_REGS[@]
set_tree_input PER_PLL_REGS[@]
set_tree_input MPU_PLL_REGS[@]
set_tree_input DDR_PLL_REGS[@]
set_tree_input DISP_PLL_REGS[@]
set_tree_input TIMERS_REGS[@]

source am335x_clk_framework_tree.sh

