constant sampler_t imageSampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP | CLK_FILTER_NEAREST;
typedef read_only image2d_t read_only_image2d_float;
__kernel void sample_kernel(read_only_image2d_float input, __global float *xOffsets, __global float *yOffsets, __global float4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1);
   int offset = tidY*get_image_width(input) + tidX;
   float2 coords = (float2)( (float)( tidX ), (float)( tidY ) );
   results[offset] = read_imagef( input, imageSampler, coords );
}