/*
 * Copyright (c) 2025, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*!****************************************************************************
 *  @file       DAP.h
 *  @brief      <b>PRELIMINARY</b> DAP interface
 *
 *  This file contains data from the application, to be modified by the user.
 *
 ******************************************************************************
 */

#ifndef ti_edgeai_DAP_interface__include
#define ti_edgeai_DAP_interface__include

#include <ti/ai/edge_ai/dap/core/DAP_core.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Capabilities */
extern const char Device_name[];     // Device Name where the firmware will be running from
extern const uint8_t SDK_version[2]; // Major, minor

/* Sensors */
extern const uint8_t availableSensorsCount;
extern const char *sensorInformation[];

/* Models - Important for model upload (if supported) */
extern uint8_t availableModelsCount;
extern const char *modelInformation[];

/* Inferences */
extern uint8_t inferencesCount;
extern const DAP_Inference inferences[];

/* Properties */
extern uint16_t propertiesCount;
extern DAP_Property properties[];

#ifdef __cplusplus
}
#endif
#endif /* ti_edgeai_DAP_interface__include */