/*
 * Copyright (c) 2025-2026, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*!****************************************************************************
 *  @file       DAP.h
 *  @brief      <b>PRELIMINARY</b> DAP interface
 *
 *  This file contains data from the application, to be modified by the user.
 *
 ******************************************************************************
 */

#include <ti/ai/edge_ai/dap/interface/DAP_interface.h>

/* Capabilities */
const char Device_name[]     = "f28p55x"; // Device Name where the firmware will be running from
const uint8_t SDK_version[2] = {9, 14};   // Major, minor

/* Sensors */
const uint8_t availableSensorsCount = 1;
const char *sensorInformation[]     = {
    // "{\"name\":\"dummy\",\"type\":7,\"dataFormat\":6,\"labels\":\"x\"}", // dummy sensor
    "{\"name\":\"PIR\",\"type\":4,\"dataFormat\":4,\"labels\":\"value\"}"};

/* Models - Important for model upload (if supported) */
uint8_t availableModelsCount   = 1;
const char *modelInformation[] = {
    // "{\"name\":\"dummy1\",\"task\":\"dummy2\",\"projectID\":\"dummy3\"}", // dummy model
    "{\"name\":\"PIR-net\",\"task\":\"PIR_classification\",\"projectID\":\"Project_Name\", \"classIdToName\":{\"0\":\"Human\",\"1\":\"Background\",\"2\":\"Dog\"}}"};

/* Inferences */
uint8_t inferencesCount          = 4;
const DAP_Inference inferences[] = {
    {"inference_result", DAP_DATA_TYPE_INT8},
    {"class0_probability", DAP_DATA_TYPE_FLOAT32},
    {"class1_probability", DAP_DATA_TYPE_FLOAT32},
    {"class2_probability", DAP_DATA_TYPE_FLOAT32},
};

/* Properties */
uint16_t propertiesCount = 2;

DAP_Property properties[] = {{"sample", DAP_DATA_TYPE_UINT32, .value.u32 = 1024},
                             {"samplingFrequency", DAP_DATA_TYPE_UINT32, .value.u32 = 33}};
