/* Copyright (C) 2025-2026 Texas Instruments Incorporated
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  ======== FEATURE_EXTRACTION.syscfg.js ========
 */

"use strict";

let Common   = system.getScript("/ti/drivers/Common.js");
let logError = Common.logError;

/*
 * ======== getLibs ========
 */
function getLibs(mod)
{
    let GenLibs = system.getScript("/ti/utils/build/GenLibs.syscfg.js");
    var toolchain = GenLibs.getToolchainDir();
    var isa = GenLibs.getDeviceIsa();

    var link_info = {
        name: "cmsisdsp",
        deps: ["/third_party"],
        libs: [
            "ti/ai/edge_ai/lib/" + toolchain + "/" + isa + "/" + "edgeai.a",
            "third_party/cmsisdsp/Source/lib/" + toolchain + "/" + isa + "/" + "cmsis_dsp_" + isa + ".a",
        ]
    };

    return link_info;
}

let config = [
    {
        name            : "adcSampleSize",
        displayName     : "ADC Sample Size",
        description     : "Number of Samples that will be processed.",
        default         : 125,
        readOnly        : true,
    },
    {
        name            : "sampling_frequency",
        displayName     : "Sampling Frequency",
        description     : "ADC Sampling Frequency (Hz).",
        default         : 25,
        readOnly        : true,
    },
    {
        name            : "padding_size_left",
        displayName     : "Padding Size - Left",
        description     : "Number of zeros added to the left of the adc samples.",
        default         : 4,
        readOnly        : true,
    },
    {
        name            : "padding_size_right",
        displayName     : "Padding Size - Right",
        description     : "Number of zeros added to the right of the adc samples.",
        default         : 3,
        readOnly        : true,
    },
    {
        name            : "padded_input_size",
        displayName     : "Padded Input Size",
        description     : "Total number of samples to be processed after padding.",
        default         : 132,
        readOnly        : true,
    },
    {
        name            : "window_size",
        displayName     : "Window Size",
        description     : "Size of the Window.",
        default         : 32,
        readOnly        : true,
    },
    {
        name            : "window_stride_size",
        displayName     : "Window Stride Size",
        description     : "Size of the stride used to get the Window.",
        default         : 4,
        readOnly        : true,
    },
        {
        name            : "num_windows",
        displayName     : "Number of Windows",
        description     : "Number of Windows based on the input size, window size and stride size.",
        default         : 25,
        readOnly        : true,
    },
    {
        name            : "fft_size",
        displayName     : "FFT Size",
        description     : "Fast Fourier Transform (FFT) Size.",
        default         : 64,
        readOnly        : true,
    },
    {
        name            : "num_bins",
        displayName     : "Number of Bins",
        description     : "Number of Frequency Bins to consider from the FFT result.",
        default         : 32,
        readOnly        : true,
    },
    {
        name            : "pooled_bins",
        displayName     : "Number of Pooled FFT Bins",
        description     : "Number of Frequency Bins to consider from the FFT result after running a x2 average pooling.",
        default         : 16,
        readOnly        : true,
    },
    {
        name            : "top_n_freq",
        displayName     : "Number of Dominant Frequencies",
        description     : "Top Max Frequencies.",
        default         : 2,
        readOnly        : true,
    },
    {
        name            : "kurtosis_chunk_size",
        displayName     : "Kurtosis Chunk Size",
        description     : "Size of the chunk used to segment a window.",
        default         : 8,
        readOnly        : true,
    },
    {
        name            : "kurtosis_stride_size",
        displayName     : "Kurtosis Stride Size",
        description     : "Size of the stride used to get a chunk from a window.",
        default         : 8,
        readOnly        : true,
    },
    {
        name            : "num_feat_fft",
        displayName     : "Number of FFT Features to build the input for the model.",
        description     : "Number of FFT Features",
        default         : 16,
        readOnly        : true,
    },
    {
        name            : "num_feat_top_freq",
        displayName     : "Number of Dominant Frequency Features",
        description     : "Number of Dominant Frequency Features to build the input for the model.",
        default         : 2,
        readOnly        : true,
    },
    {
        name            : "num_feat_kurtosis",
        displayName     : "Number of Kurtosis Features",
        description     : "Number of Kurtosis Features to build the input for the model.",
        default         : 4,
        readOnly        : true,
    },
    {
        name            : "num_feat_zcr",
        displayName     : "Number of Zero Crossing Rate Features",
        description     : "Number of Zero Crossing Rate Features to build the input for the model.",
        default         : 1,
        readOnly        : true,
    },
    {
        name            : "num_feat_slope",
        displayName     : "Number of Slope Features",
        description     : "Number of Slope Features to build the input for the model.",
        default         : 1,
        readOnly        : true,
    },
    {
        name            : "num_feat_pw_spec",
        displayName     : "Number of Power Spectrum Features",
        description     : "Number of Power Spectrum Features to build the input for the model.",
        default         : 1,
        readOnly        : true,
    },
    {
        name            : "num_feat_total",
        displayName     : "Total Number of Features",
        description     : "Number of Total Features to build the input for the model.",
        default         : 25,
        readOnly        : true,
    },
    {
        name            : "num_classes",
        displayName     : "Total Number of Classes",
        description     : "Number of Total Classes output by the Model",
        default         : 3,
        readOnly        : true,
    },
];


/*
 *  ======== base ========
 */
let base = {
    displayName: "Feature Extraction",
    longDescription: `
The Feature Extraction Library serves as a pre-processing stage where raw signal 
inputs will be fed to a set of signal process functions and the resulting output
will be fed into the pre-compiled NN model.

The functions work with a set of predefined parameters that are currently fixed to 
fit the input requirements of the PIR model.
`,
    defaultInstanceName: "CONFIG_FEAT_EXTRACT_",
    config             : config,
    maxInstances: 1,
    templates: {
        "/ti/ai/edge_ai/templates/edgeai_template.h.xdt": true,
        "/ti/ai/edge_ai/templates/edgeai_template.c.xdt": true,
        "/ti/ai/edge_ai/templates/fe_parameters_template.h.xdt": true,
        "/ti/utils/build/GenLibs.cmd.xdt": { modName: "/ti/ai/edge_ai/FeatureExtraction", getLibs: getLibs }
    }
};

exports = base;