#
#   Copyright (c) 2023-2026, Texas Instruments Incorporated
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   *  Redistributions of source code must retain the above copyright
#      notice, this list of conditions and the following disclaimer.
#
#   *  Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   *  Neither the name of Texas Instruments Incorporated nor the names of
#      its contributors may be used to endorse or promote products derived
#      from this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
#   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
#   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
#   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#   OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
#   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
#   OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
#   EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#
#  ======== imports.mak ========
#

# Paths to required dependencies for SimpleLink SDKs
# Set the appropriate SDK path(s) for your target device:
#   - CC27XX devices: Set SIMPLELINK_LOWPOWER_F3_SDK_INSTALL_DIR
#   - CC13XX/CC26XX devices: Set SIMPLELINK_CC13XX_CC26XX_SDK_INSTALL_DIR
#   - CC35XX devices: Set SIMPLELINK_WIFI_SDK_INSTALL_DIR and SIMPLELINK_WIFI_TOOLBOX_INSTALL_DIR

# SIMPLELINK_LOWPOWER_F3_SDK_INSTALL_DIR is the location of your LPF3 SDK (for CC27XX).
SIMPLELINK_LOWPOWER_F3_SDK_INSTALL_DIR ?=

# SIMPLELINK_CC13XX_CC26XX_SDK_INSTALL_DIR is the location of your CC13XX_CC26XX SDK.
SIMPLELINK_CC13XX_CC26XX_SDK_INSTALL_DIR ?=

# SIMPLELINK_WIFI_SDK_INSTALL_DIR is the location of your WiFi SDK (for CC35XX).
SIMPLELINK_WIFI_SDK_INSTALL_DIR ?=

# SIMPLELINK_WIFI_TOOLBOX_INSTALL_DIR is the location of your WiFi Toolbox (required for CC35XX).
SIMPLELINK_WIFI_TOOLBOX_INSTALL_DIR ?=

# Import settings from LPF3 SDK (if set)
ifneq ($(SIMPLELINK_LOWPOWER_F3_SDK_INSTALL_DIR),)
include $(SIMPLELINK_LOWPOWER_F3_SDK_INSTALL_DIR)/imports.mak
endif

# Import settings from CC13XX_CC26XX SDK (if set)
ifneq ($(SIMPLELINK_CC13XX_CC26XX_SDK_INSTALL_DIR),)
include $(SIMPLELINK_CC13XX_CC26XX_SDK_INSTALL_DIR)/imports.mak
endif

# Import settings from WiFi SDK (if set)
ifneq ($(SIMPLELINK_WIFI_SDK_INSTALL_DIR),)
include $(SIMPLELINK_WIFI_SDK_INSTALL_DIR)/imports.mak
endif
