## Introduction

This CC33xx RTOS MCU Software Package delivers components that enable engineers to develop applications on the Texas Instruments CC33xx Wi-Fi devices and Sitara family of microcontrollers (MCU).

This software toolkit provides the drivers for CC33xx devices to be used with a Real-Time Operating System (RTOS) on a microcontroller.

This is version R8.1 of the CC33xx RTOS MCU Software Package.

> Disclaimer: 
>
> The purpose of this CC33xx RTOS MCU software package is to provide a prototype for customers to start evaluating AM243x and CC33xx. This is not a fully productized release.


# Release highlights for patch version R8.1

* Fixed issue - Connection with PMF doesnt send deauth frame secured
* Feature Enhancement: One-Shot Channel List Scanning - Added ability to limit Wi-Fi scans or connections to a specific, user-defined channel list.
    * Use WLAN_SET_LISTED_CHANNELS_FOR_SCAN with Wlan_Set to define your desired channels.
    * This configuration is a one-time operation. Subsequent scans or connections will automatically default back to scanning all channels.
    * To manually clear the list, provide a NULL pointer to the Wlan_Set operation.
* Various code cleanup 


# Release highlights for Base version R8

* Added support for WPA, WPA/WPA2 mixed mode
* WPA2-WPA3 transition mode - can connect to such network using WPA2+PMF security type
    * Connect with WPA3 to a transition network is still under work
* Various code cleanup 
* General bugs fixes 

# Supported Features

* WiFi Features
    * Supported Wi-Fi Roles: Station (STA), Access Point (AP)
    * Supports IEEE 802.11 a,b,g,n,ax (ax in STA role only)
    * Supported band: 2.4GHz / 5GHz 
    * STA security: WPA/WPA2 mixed mode, WPA2 personal, WPA3 personal, Open
    * AP security: WPA2 personal, Open
    * AP role supports up to 4 peers
    * Multirole - STA role and AP role running in parallel
    * Wi-Fi/BLE coex
    * Coexistence with external 2.4GHz radios - Not fully not optimized
    * LSI (Long Sleep Interval) support
    * Channel Switch Announcement support in Station role
    * Reg domain support
* BLE Features
    * BLE 5.4 Qualified
    * Supported BLE roles:  Broadcaster, Peripheral, Observer, Central, Multirole
    * Legacy & Extended Advertisement
    * Legacy & Extended Scan
    * Multiple BLE Connections
    * Supported PHYs: 1M, 2M, Coded
    * TX power control
    * Privacy
    * Secured connection

## Documentation

* [User's Guide](./docs/CC33XX-Mcu-User-Guide.html)

## Operating Systems Support

* Windows 10
* Ubuntu 

## Dependencies

This release was validated with the following components:

* [Code Composer Studio 12.1.0](http://processors.wiki.ti.com/index.php/Download_CCS)
* [TI-Clang 2.1.2 LTS](https://www.ti.com/tool/download/ARM-CGT-CLANG/2.1.2.LTS)

# Components version:

* FW version: 1.7.0.329
* PHY version: 1.2.0.47.6.13.37.69
* RAM Bootloader version: 1.0.0.30

## Device Support

* CC33xx ICs
  * CC3301
  * CC3351

## Resolved Issues 

${CC33XX_TM_FI_R8}

## Known Issues

> Due to a migration in the Jira project, some known issues from the previous release have been reassigned with new issue key IDs

${CC33XX_TM_KI}

## Limitations

* BLE Limitations
	* Wlan_Start must be used before the call to BLE_Start API
* AP 5GHz not supported


## Last releases

Version R7.1
* Updated to latest RAM bootloader (was 1.0.0.26)

Version R7
* Added support for station regulatory domain
    * Configuring regulatory domain is done by using the Wlan_RoleUp() 
      Command/API with EU,US,JP,CSI(custom) as a parameter.
    * for custom fields, use Wlan_Set with the WLAN_SET_CUSTOM_DOMAIN_ENTRY    
    * more information is in the wlan_if.h file
* Scan mechanism improvements
* Various MultiRole bug fixes
* General bugs fixes in the following table:

${CC33XX_TM_FI_R7}

## Technical Support and Product Updates

* [Wi-Fi E2E Forums](http://e2e.ti.com/support/wireless-connectivity/wi-fi-group/wifi/f/wi-fi-forum/)
* [www.ti.com](http://www.ti.com/)


